package com.mmc.iuav.user.service.dronepilot;

import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.dto.dronepilot.PilotAbilityDTO;
import com.mmc.iuav.user.model.dto.dronepilot.PilotCertificationDTO;
import com.mmc.iuav.user.model.dto.dronepilot.PilotCertificationInteriorDTO;
import com.mmc.iuav.user.model.dto.dronepilot.PilotReasonDTO;
import com.mmc.iuav.user.model.qo.dronepilot.*;
import com.mmc.iuav.user.model.vo.CompanyInfoVO;
import com.mmc.iuav.user.model.vo.dronepilot.PilotCertificationVO;

/**
 * @Author small
 * @Date 2023/7/28 9:35
 * @Version 1.0
 */
public interface PilotCertificationService {

    ResultBody insertPilot(PilotCertificationVO certificationVO, LoginSuccessDTO userLoginInfoFromRedis);

    ResultBody<PilotAbilityDTO> abilityList();

    ResultBody updatePilot(PilotCertificationVO certificationVO, LoginSuccessDTO userLoginInfoFromRedis);


    PageResult pilotList(PilotCertificationQO param);

    PilotCertificationDTO detailPilot(Integer id);

    PilotCertificationDTO userDetailPilot(Integer userAccountId);

    PageResult backListPilot(PilotCertificationQO param, LoginSuccessDTO userLoginInfoFromRedis);

    ResultBody getPilotAuditSum();
    ResultBody updateRemark(PilotRemarkQO param, LoginSuccessDTO userLoginInfoFromRedis);

    ResultBody updateAuditStatus(PilotAuditStatusQO param, LoginSuccessDTO userLoginInfoFromRedis);

    PageResult backPilotLogList(PilotCertificationLogQO param, LoginSuccessDTO userLoginInfoFromRedis);

    ResultBody<PilotReasonDTO> backListReason();

    PilotCertificationInteriorDTO interiorDetailPilot(Integer userAccountId);

    ResultBody insertPilotJoinTeam(Integer pilotId,Integer backId);

    ResultBody selectPilotByPhone(String phoneNumber);

    PageResult selectPilotListByTeam(PilotTeamQO param,Integer backId);

    ResultBody updatePilotStatus(Integer userId,Integer pilotStatus);

    ResultBody selectCompanyInfoByPilotId(Integer pilotId);
}
