package com.mmc.iuav.user.controller.fdd;

/**
 * @Author LW
 * @date 2022/8/31 15:28
 * 概要：
 */

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.fdd.dto.SealInfoDTO;
import com.mmc.iuav.user.model.fdd.vo.SealInfoVO;
import com.mmc.iuav.user.model.fdd.vo.SealVO;
import com.mmc.iuav.user.service.fdd.SealManageService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 * @date 2022/8/3 10:22
 * 概要：
 */
@Api(tags = {"印章管理模块-接口"})
@RequestMapping("/seal/")
@RestController
public class SealManageController extends BaseController {

    @Autowired
    private SealManageService sealManageService;

    @ApiOperation(value = "上传印章")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/uploadSeal")
    public ResultBody uploadSeal(@RequestBody SealVO sealVO, HttpServletRequest request) {
        return sealManageService.uploadSeal(sealVO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "当前用户印章列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = SealInfoDTO.class)})
    @PostMapping("/getSealInfoList")
    public ResultBody getSealInfoList(HttpServletRequest request, @RequestBody SealInfoVO param) {
        return ResultBody.success(sealManageService.getSealInfoList(param, this.getUserLoginInfoFromRedis(request)));
    }

    @ApiOperation(value = "删除印章")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/removeSeal")
    public ResultBody removeSeal(@ApiParam(value = "印章编号") @RequestParam(value = "signatureId") String signatureId,
                                 @ApiParam(value = "端口 0小程序 1后台") Integer port,
                                 HttpServletRequest request) {
        return sealManageService.removeSeal(signatureId, port, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "设置默认签章")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/defaultSeal")

    public ResultBody defaultSeal(@ApiParam(value = "印章编号") @RequestParam(value = "signatureId") String signatureId,
                                  @ApiParam(value = "端口 0小程序 1后台") Integer port,
                                  HttpServletRequest request) {
        return sealManageService.defaultSeal(signatureId, port, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "查看印章信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/getSealInfo")

    public ResultBody getSealInfo(@ApiParam(value = "印章编号") @RequestParam(value = "signatureId") String signatureId,
                                  @ApiParam(value = "端口 0小程序 1后台") Integer port,
                                  HttpServletRequest request) {
        return sealManageService.getSealInfo(signatureId, port, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "编辑印章名称")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/editSealName")
    public ResultBody editSealName(@ApiParam(value = "印章编号") @RequestParam(value = "signatureId") String signatureId,
                                   @ApiParam(value = "端口 0小程序 1后台") Integer port,
                                   @ApiParam(value = "要修改的印章名称") String sealName,
                                   HttpServletRequest request) {
        return sealManageService.editSealName(signatureId, port, this.getUserLoginInfoFromRedis(request), sealName);
    }

}
