package com.mmc.iuav.user.model.dto.userpoints;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/5 16:33
 * @Version 1.0
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
public class UserPointsDTO {

    @ApiModelProperty(value = "积分id", example = "1")
    private Integer id;

    @ApiModelProperty(value = "微信昵称", example = "张三")
    private String nickName;

    @ApiModelProperty(value = "手机号", example = "189213123312")
    private String phoneNum;

    @ApiModelProperty(value = "用户id", example = "1")
    private Integer userAccountId;

    @ApiModelProperty(value = "积分总额", example = "3")
    private Integer totalPoints;

    @ApiModelProperty(value = "创建时间", example = "2023-08-05 16:25:02")
    private Date createTime;

    @ApiModelProperty(value = "更新时间", example = "2023-08-05 16:25:02")
    private Date updateTime;


}
