package com.mmc.iuav.user.model.dto.dronepilot;

import com.alibaba.fastjson2.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author small
 * @Date 2023/7/29 17:09
 * @Version 1.0
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PilotCertificationLogDTO {

    @ApiModelProperty(value = "id", example = "1")
    private Integer id;
    @ApiModelProperty(value = "审批及认证时间", example = "1")
    private Date certificationDate;
    @ApiModelProperty(value = "申请人员的id", example = "1")
    private Integer userAccountId;
    @ApiModelProperty(value = "申请人员的账号名称", example = "1")
    private String userName;
    @ApiModelProperty(value = "申请及审批信息", example = "1")
    private String certificationMessage;
    @ApiModelProperty(value = "操作人员id", example = "1")
    private Integer operatorUserId;
    @ApiModelProperty(value = "操作人员账号", example = "1")
    private String operatorUserAccount;
    @ApiModelProperty(value = "操作人员名称", example = "1")
    private String operatorUserName;
    @ApiModelProperty(value = "手机号", example = "1")
    private String phoneNum;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
