package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.UserAccountSimpleDTO;
import com.mmc.iuav.user.model.vo.AppUserSucVO;
import com.mmc.iuav.user.model.vo.UserAccountVO;
import com.mmc.iuav.user.model.vo.WxLoginVO;
import com.mmc.iuav.user.service.UserAccountService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author: zj
 * @Date: 2023/5/15 15:32
 */
@Api(tags = "账号相关接口")
@RequestMapping("/user-account/")
@RestController
public class UserAccountController {

    @Autowired
    private UserAccountService userAccountService;

    @ApiOperation(value = "获取用户信息")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = UserAccountVO.class) })
    @GetMapping("info")
    public UserAccountVO info(@RequestParam Integer userAccountId){
        return userAccountService.getUserAccountById(userAccountId);
    }

    @ApiOperation(value = "修改用户信息")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("update")
    public ResultBody update(@Validated(value = {Update.class})@RequestBody UserAccountVO userAccountVO){
        return userAccountService.update(userAccountVO);
    }

    @ApiOperation(value = "获取用户基本信息")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = UserAccountSimpleDTO.class) })
    @GetMapping("feignGetUserSimpleInfo")
    public UserAccountSimpleDTO feignGetUserSimpleInfo(@RequestParam Integer userAccountId){
        return userAccountService.getUserSimpleInfo(userAccountId);
    }

}
