package com.mmc.iuav.user.controller.wallet;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.qo.wallet.WalletFlowQO;
import com.mmc.iuav.user.model.vo.wallet.ApplyWithdrawalVO;
import com.mmc.iuav.user.service.xzsz.WithdrawalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/8/23 15:58
 */
@Slf4j
@Api(tags = "提现相关")
@RequestMapping("/withdrawal/")
@RestController
public class WithdrawalController extends BaseController {

    @Autowired
    private WithdrawalService withdrawalService;

    @ApiOperation(value = "提现申请")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("apply")
    public ResultBody apply(@RequestBody ApplyWithdrawalVO applyWithdrawalVO, HttpServletRequest request) {
        return withdrawalService.apply(applyWithdrawalVO, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    // 提现查询

    @ApiOperation(value = "个人提现明细列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("withdrawalList")
    public ResultBody withdrawalList(HttpServletRequest request, @RequestBody WalletFlowQO walletFlowQO) {
        return withdrawalService.withdrawalList(this.getUserLoginInfoFromRedis(request).getUserAccountId(), walletFlowQO);
    }

    // 全部用户提现列表

}
