package com.mmc.iuav.user.service.userpoints.impl;

import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.user.dao.userpoints.UserPointsDao;
import com.mmc.iuav.user.dao.userpoints.UserPointsDetailsDao;
import com.mmc.iuav.user.entity.userpoints.UserPointsDO;
import com.mmc.iuav.user.entity.userpoints.UserPointsDetails;
import com.mmc.iuav.user.model.dto.userpoints.UserPointsDTO;
import com.mmc.iuav.user.model.dto.userpoints.UserPointsDetailsDTO;
import com.mmc.iuav.user.model.qo.userpoints.AppPointsDetailsQO;
import com.mmc.iuav.user.model.qo.userpoints.UserPointQO;
import com.mmc.iuav.user.model.qo.userpoints.UserPointsDetailsQO;
import com.mmc.iuav.user.service.userpoints.UserPointsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author small
 * @Date 2023/8/5 16:31
 * @Version 1.0
 */
@Service
public class UserPointsServiceImpl implements UserPointsService {

    @Autowired
    private UserPointsDao userPointsDao;

    @Autowired
    private UserPointsDetailsDao userPointsDetailsDao;

    @Override
    public PageResult userPointList(UserPointQO param) {
        int count = userPointsDao.count(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<UserPointsDO> userPointList = userPointsDao.userPointList(param);
        List<UserPointsDTO> collect = userPointList.stream().map(UserPointsDO::buildUserPointsDTO).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);

    }

    @Override
    public PageResult detailPoint(UserPointsDetailsQO param) {
        int count = userPointsDetailsDao.detailPointCount(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<UserPointsDetails> userPointsDetails = userPointsDetailsDao.detailPoint(param);
        List<UserPointsDetailsDTO> collect = userPointsDetails.stream().map(UserPointsDetails::buildPoint).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);
    }

    @Override
    public PageResult appDetailPoint(Integer userAccountId, AppPointsDetailsQO param) {
        param.setUserAccountId(userAccountId);
        int count = userPointsDetailsDao.appDetailPointCount(param);
        if (count == 0) {
            return PageResult.buildPage(param.getPageNo(), param.getPageSize(), count);
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<UserPointsDetails> userPointsDetails = userPointsDetailsDao.appDetailPoint(param);
        List<UserPointsDetailsDTO> collect = userPointsDetails.stream().map(UserPointsDetails::buildPoint).collect(Collectors.toList());
        return PageResult.buildPage(pageNo, param.getPageSize(), count, collect);
    }
}
