package com.mmc.iuav.user.error;

import com.mmc.iuav.http.BizException;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.List;
import java.util.stream.Collectors;


/**
 * @author 作者 geDuo
 * @version 创建时间：2021年8月27日 上午10:15:30
 * @explain 类说明
 */
@ControllerAdvice
public class GlobalExceptionHandler {
    /**
     * 统一处理参数校验错误异常(非Spring接口数据绑定验证)
     *
     * @param e
     * @return
     */
    @ExceptionHandler(BindException.class)
    @ResponseBody
    public ResultBody processValidException(BindException e) {
        // 获取校验错误结果信息，并将信息组装
        List<String> errorStringList = e.getBindingResult().getAllErrors().stream().map(ObjectError::getDefaultMessage)
                .collect(Collectors.toList());
        String errorMessage = String.join("; ", errorStringList);
        return ResultBody.error(ResultEnum.BODY_NOT_MATCH.getResultCode(), errorMessage);
    }

    /**
     * 统一处理参数校验错误异常
     *
     * @param e
     * @return
     */
    @ExceptionHandler(IllegalArgumentException.class)
    @ResponseBody
    public ResultBody processValidException(IllegalArgumentException e) {
        String errorMessage = String.join("; ", e.getMessage());
        return ResultBody.error(ResultEnum.BODY_NOT_MATCH.getResultCode(), errorMessage);
    }

    @ExceptionHandler(ConstraintViolationException.class)
    @ResponseBody
    public ResultBody processValidException(ConstraintViolationException e) {
        String errorMessage = e.getConstraintViolations().stream().map(ConstraintViolation::getMessage)
                .collect(Collectors.joining(","));
        return ResultBody.error(ResultEnum.BODY_NOT_MATCH.getResultCode(), errorMessage);
    }

    @ExceptionHandler(MethodArgumentNotValidException.class)
    @ResponseBody
    public ResultBody processValidException(MethodArgumentNotValidException e) {
        String errorMessage = e.getBindingResult().getAllErrors().stream()
                .map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(","));
        return ResultBody.error(ResultEnum.BODY_NOT_MATCH.getResultCode(), errorMessage);
    }

    @ExceptionHandler(MissingServletRequestParameterException.class)
    @ResponseBody
    public ResultBody processValidException(MissingServletRequestParameterException e) {
        String errorMessage = e.getParameterName() + " 不能为空";
        return ResultBody.error(ResultEnum.BODY_NOT_MATCH.getResultCode(), errorMessage);
    }

    @ExceptionHandler(MissingPathVariableException.class)
    @ResponseBody
    public ResultBody processValidException(MissingPathVariableException e) {
        String errorMessage = e.getVariableName() + " 不能为空";
        return ResultBody.error(ResultEnum.BODY_NOT_MATCH.getResultCode(), errorMessage);
    }

    @ExceptionHandler(BizException.class)
    @ResponseBody
    public ResultBody processValidException(BizException e) {
        return ResultBody.error(e.getErrorCode(), e.getErrorMsg());
    }
}
