package com.mmc.iuav.user.controller.signin;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.entity.signin.SignInDO;
import com.mmc.iuav.user.entity.signin.SignInRecordDO;
import com.mmc.iuav.user.model.dto.signin.SignInDTO;
import com.mmc.iuav.user.model.vo.signin.AppSignInVO;
import com.mmc.iuav.user.model.vo.signin.SignInVO;
import com.mmc.iuav.user.service.signin.SignInService;
import io.jsonwebtoken.SigningKeyResolver;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Base64;
import java.util.List;

/**
 * @Author small
 * @Date 2023/10/13 9:32
 * @Version 1.0
 */
@RestController
@Api(tags = "签到")
public class SignInController extends BaseController {

    @Autowired
    private SignInService signInService;

    @ApiOperation("后台——签到调整")
    @PostMapping("/insertSignIn")
    public ResultBody SignIn(@RequestBody SignInVO signInVO, HttpServletRequest request){
        return signInService.SignIn(signInVO);
    }

    @ApiOperation("小程序签到列表")
    @GetMapping("/SignInList")
    public ResultBody<SignInDTO> SignInList(HttpServletRequest request){
        List<SignInDTO> signInDOS = signInService.SignInList();
        return ResultBody.success(signInDOS);
    }

    @ApiOperation("小程序签到")
    @PostMapping("/appSignIn")
    public ResultBody appSignIn(HttpServletRequest request, @RequestBody AppSignInVO appSignInVO){
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        appSignInVO.setUserAccountId(userAccountId);
        return signInService.appSignIn(appSignInVO);
    }


    @ApiOperation("小程序签到记录")
    @GetMapping("/signInRecord")
    public ResultBody<SignInRecordDO> signInRecord(HttpServletRequest request){
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
    return ResultBody.success(signInService.signInRecord(userAccountId));
    }








}
