package com.mmc.iuav.user.model.vo.wallet;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author LW
 * @date 2023/8/24 14:37
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class UserBillingDetailVO implements Serializable {

    private static final long serialVersionUID = -113701726830167312L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;
    @ApiModelProperty(value = "流水编号")
    private String payNo;
    @ApiModelProperty(value = "操作方式 100（订单发布） 200(无人接单取消订单）300（有人接单取消订单）400（飞手抢单）500（客服判定飞手无责取消订单）" +
            "600（飞手有责取消订单）700（正常结算）800(修改订单金额状态)900（飞手未确认修改金额状态）1000（飞手确认修改金额状态）1100（充值） 1200（提现）")
    private Integer payMethod;
    @ApiModelProperty(value = "云享金变动金额(正数充值，负数扣除)")
    private BigDecimal cashAmtPaid;
    @ApiModelProperty(value = "佣金变动金额(正数入账，负数扣除)")
    private BigDecimal salaryAmtPaid;
    @ApiModelProperty(value = "操作时间")
    private Date payTime;
    @ApiModelProperty(value = "操作名称")
    private String name;
}
