/*
 * Decompiled with CFR 0.152.
 */
package com.fadada.sdk.api;

import com.fadada.sdk.api.API;
import com.fadada.sdk.api.ApiParams;
import com.fadada.sdk.enums.ErrorMessage;
import com.fadada.sdk.exception.SDKException;
import com.fadada.sdk.utils.CheckUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractAPI
implements API {
    protected ApiParams apiParams;
    protected Map<String, String> headers = new HashMap<String, String>();

    @Override
    public ApiParams getAPIParams() {
        return this.apiParams;
    }

    @Override
    public void setAPIParams(ApiParams apiParams) {
        this.apiParams = apiParams;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void addHeader(String headerName, String headerValue) throws SDKException {
        CheckUtils.checkArgument(StringUtils.isNotBlank(headerName), ErrorMessage.PARAM_ERROR, "headerName can not be null!");
        CheckUtils.checkArgument(StringUtils.isNotBlank(headerValue), ErrorMessage.PARAM_ERROR, "headerValue can not be null!");
        this.headers.put(headerName, headerValue);
    }

    @Override
    public String getVersion() {
        return "2.0";
    }

    @Override
    public boolean hasFile() {
        return false;
    }

    @Override
    public boolean hasDownload() {
        return false;
    }
}

