package com.mmc.iuav.user.model.vo;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.group.UpdatePassword;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/5/25 11:15
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BUserAccountVO implements Serializable {
    private static final long serialVersionUID = -5809674104674997410L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "更新时ID不能为空", groups = {Update.class, UpdatePassword.class})
    private Integer id;

    @ApiModelProperty(value = "账号", example = "developer")
    @NotEmpty(message = "账号不能为空", groups = {Create.class, Update.class})
    private String accountNo;

    @ApiModelProperty(value = "姓名", example = "张三丰")
    @NotEmpty(message = "姓名不能为空", groups = {Create.class, Update.class})
    private String userName;

    @ApiModelProperty(value = "电话", example = "13700137000")
    @NotEmpty(message = "创建，修改时电话不能为空", groups = {Create.class, Update.class})
    private String phoneNum;

    @ApiModelProperty(value = "密码", example = "123456")
    @NotEmpty(message = "创建密码不能为空", groups = {Create.class, UpdatePassword.class})
    private String passWord;

    @ApiModelProperty(value = "确认密码", example = "123456")
    @NotEmpty(message = "确认密码不能为空", groups = {Create.class, UpdatePassword.class})
    private String alertPwd;

    @ApiModelProperty(value = "备注", example = "一个备注")
    private String remark;

    @ApiModelProperty(value = "状态", example = "1")
    @NotNull(message = "状态不能为空", groups = {Update.class})
    private Integer accountStatus;

    @ApiModelProperty(value = "角色", example = "1", hidden = true)
    //@NotNull(message = "角色不能为空", groups = {Create.class, Update.class})
    private Integer roleId;

    @ApiModelProperty(value = "能控制的用户资源来源",hidden = true)
    private Integer controlSource;

    @ApiModelProperty(value = "电子邮箱", example = "220700100213@163.com")
    @Email
    private String email;

    @ApiModelProperty(value = "所属公司ID",example = "1", hidden = true)
    private Integer companyId;

    @ApiModelProperty(value = "账号类型：0合伙人 1员工", example = "1", hidden = true)
    private Integer userType;

    @ApiModelProperty(value = "省份编码", required = false)
    private Integer provinceCode;

    @ApiModelProperty(value = "城市编码", required = false)
    private Integer cityCode;

    @ApiModelProperty(value = "县区编码", required = false)
    private Integer districtCode;
}
