package com.mmc.iuav.user.util;

import com.mmc.iuav.user.model.dto.MenuInfoDTO;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zj
 */
public class MenuTreeUtil {
    public final static Integer IUAV_PC_MENU_PID = 1;
    public final static String IUAV_PC_MENU_NAME = "云享飞管理后台";

    public static void builderTree(List<MenuInfoDTO> treeEntityList, MenuInfoDTO pTreeEntity) {
        List<MenuInfoDTO> childMenus = new ArrayList<MenuInfoDTO>();

        for (MenuInfoDTO menuInfo : treeEntityList) {
            // int的对比范围有限所以需要使用equals
            if ((menuInfo.getPid().toString()).equals(pTreeEntity.getId().toString())) {
                childMenus.add(menuInfo);
            }
        }

        if (childMenus.size() > 0) {
            pTreeEntity.setChildren(childMenus);
        } else {
            return;
        }

        for (MenuInfoDTO children : childMenus) {
            treeEntityList.remove(children);
        }

        if (treeEntityList.size() > 0) {
            for (MenuInfoDTO children : childMenus) {
                builderTree(treeEntityList, children);
            }
        }
    }

    /**
     * 获取云享飞管理后台菜单列表
     *
     * @return
     */
    public static MenuInfoDTO buildTreePCMenu(List<MenuInfoDTO> treeEntityList) {
        MenuInfoDTO parent = new MenuInfoDTO();
        parent.setId(MenuTreeUtil.IUAV_PC_MENU_PID);
        parent.setMenuName(IUAV_PC_MENU_NAME);
        MenuTreeUtil.builderTree(treeEntityList, parent);
        return parent;
    }
}
