package com.mmc.iuav.user.service;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.vo.AppletMsgVO;
import com.mmc.iuav.user.model.vo.WxLoginVO;
import com.mmc.iuav.user.model.vo.WxMsgVO;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/5/16 13:43
 */
public interface WxService {
    /**
     * 小程序登录调用接口
     * @param wxLoginVO
     * @return
     */
    String appLogin(WxLoginVO wxLoginVO);

    /**
     * pc扫码登录
     * @param wxLoginVO
     * @return
     */
    String pcLogin(WxLoginVO wxLoginVO);

    /**
     * 获取AccessToken
     * @return
     */
    String getAccessToken();

    /**
     * 获取稳定AccessToken
     * @return
     */
    String getStableAccessToken() throws Exception;

    /**
     * 获取公众号AccessToken
     * @return
     */
    String getSubAccessToken();

    /**
     * 监控微信公众号的事件变化通知
     * @param request
     */
    String receiveSubAccountEvents(HttpServletRequest request);

    /**
     * 公众号推送模板消息-不需要用户同意
     * @return
     */
    ResultBody sendSubTemplateMsg(WxMsgVO ws);

    /**
     * 获取不限制的小程序码
     * @param path
     * @param scene
     */
    ResultBody getUnLimitedQRCode(String path, String scene);

    /**
     * 小程序推送订阅号消息-需用户同意订阅
     * @param appletMsgVO
     */
    ResultBody sendAppletMsg(AppletMsgVO appletMsgVO);

    /**
     * 生成小程序链接
     * @param path
     * @param query
     * @return
     */
    String createUrlLink(String path, String query);

    /**
     * 获取用户授权手机号
     *
     * @param id
     * @param code
     * @return
     */
    String getUserPhoneNumber(Integer id, String code);
}
