package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.dto.UserSubInfoDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/24 15:08
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserSubInfoDO implements Serializable {
    private static final long serialVersionUID = 8534660282946889549L;
    private Integer id;
    private String openId;
    private String unionId;
    private String nickName;
    private Integer regStatus;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    public UserSubInfoDTO buildUserSbuInfoDTO() {
        return UserSubInfoDTO.builder().openId(openId).unionId(unionId).subscribe(this.deleted == 0 ? 1 : 0).build();
    }
}
