package com.mmc.iuav.user.client;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/**
 * @author: zj
 * @Date: 2023/7/4 13:46
 */
@Component
public class PmsClient {
    @Value("${iuav.pms.uri}")
    private String pmsAppUri;

    @Autowired
    private RestTemplate restTemplate;

    public Integer countCompanyTasks(Integer id, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("token", token);
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<ResultBody> responseEntity = restTemplate.exchange(pmsAppUri+"/pms/backstage/work/queryWorkServiceCount" + "?companyId=" + id, HttpMethod.GET, entity, ResultBody.class);
        ResultBody body = responseEntity.getBody();
        if (body.getCode().equals(ResultEnum.SUCCESS.getResultCode())){
            Integer count = (Integer) body.getResult();
            return count;
        }
        return null;
    }
}
