package com.mmc.iuav.user.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/7/11 14:25
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "菜单DTO")
public class MenuInfoDTO implements Serializable {
    private static final long serialVersionUID = -4144480758801282377L;
    private Integer id;
    @ApiModelProperty(value = "上级ID")
    private Integer pid;
    @ApiModelProperty(value = "菜单名称")
    private String menuName;
    @ApiModelProperty(value = "元素类型：0菜单 1按钮")
    private String domType;
    @ApiModelProperty(value = "路由地址")
    private String pathInfo;
    @ApiModelProperty(value = "图标")
    private String icon;
    @ApiModelProperty(value = "下级菜单列表")
    private List<MenuInfoDTO> children;

}
