package com.mmc.iuav.user.model.vo;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/5/17 13:42
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CompanyAuthVO implements Serializable {
    private static final long serialVersionUID = 3584743219477515646L;
    @ApiModelProperty(value = "id")
    @NotNull(message = "id创建修改不能为空", groups = { Update.class })
    private Integer id;
    @ApiModelProperty(value = "用户id", hidden = true)
    //@NotNull(message = "用户id不能为空", groups = { Insert.class, Update.class})
    private Integer userAccountId;
    @ApiModelProperty(value = "企业名称")
    @NotBlank(message = "企业名称", groups = { Insert.class, Update.class})
    private String companyName;
    @ApiModelProperty(value = "统一社会信用代码")
    @NotBlank(message = "统一社会信用代码", groups = { Insert.class, Update.class})
    private String creditCode;
    @ApiModelProperty(value = "营业执照")
    @NotBlank(message = "营业执照", groups = { Insert.class, Update.class })
    private String licenseImg;
    @ApiModelProperty(value = "企业认证状态，0未通过，1已通过")
    private Integer authStatus;
}
