package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.dto.WebsiteRangeDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author LW
 * @date 2022/4/21 20:09 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class WebsiteInfoDO implements Serializable {
    private Integer id;
    private String name;
    private String address;
    private Double lat;
    private Double lon;
    private Double distance;
    private Integer type;
    private Integer userApplyTag;

    private String content;
    private Integer score;


    public WebsiteRangeDTO buildWebsiteRangeDTO() {
        this.distance = this.distance == null ? 0 : (BigDecimal.valueOf(this.distance).setScale(2, BigDecimal.ROUND_HALF_DOWN)).doubleValue();
        return WebsiteRangeDTO.builder()
                .name(name)
                .address(address)
                .lon(this.lon)
                .lat(this.lat)
                .content(content)
                .score(score)
                .distance(this.distance / 1000)
                .build();
    }
}
