package com.mmc.iuav.user.service.impl;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import com.mmc.iuav.user.dao.CompanyAuthDao;
import com.mmc.iuav.user.dao.CooperationDao;
import com.mmc.iuav.user.entity.CompanyAuthDO;
import com.mmc.iuav.user.entity.CooperationTagDO;
import com.mmc.iuav.user.entity.UserApplyTagDO;
import com.mmc.iuav.user.entity.UserTagDO;
import com.mmc.iuav.user.model.vo.CooperationTagVO;
import com.mmc.iuav.user.model.vo.UserApplyTagVO;
import com.mmc.iuav.user.model.vo.UserCooperationTagVO;
import com.mmc.iuav.user.service.CooperationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/5/17 21:19
 */
@Service
public class CooperationServiceImpl implements CooperationService {
    @Autowired
    private CooperationDao cooperationDao;

    @Autowired
    private CompanyAuthDao companyAuthDao;

    @Override
    public List<CooperationTagVO> listTag() {
        List<CooperationTagDO> list = cooperationDao.listTags();
        List<CooperationTagVO> resList = list.stream().map(CooperationTagDO::buildCooperationTagVO).collect(Collectors.toList());
        return resList;
    }

    @Override
    public ResultBody apply(UserApplyTagVO userApplyTagVO) {
        //判断企业认证
        CompanyAuthDO companyAuthDO = companyAuthDao.getCompanyAuth(userApplyTagVO.getUserAccountId());
        if (companyAuthDO == null) {
            return ResultBody.error(ResultEnum.COMPANY_NOT_AUTH_ERROR);
        }
        UserApplyTagDO userApplyTagDO = new UserApplyTagDO(userApplyTagVO);
        //判断是否已加盟
        UserApplyTagDO existUserApplyTagDO = cooperationDao.getUserApplyTag(userApplyTagVO.getUserAccountId());
        if (existUserApplyTagDO != null) {
            cooperationDao.updateUserApplyTag(userApplyTagDO);
            return ResultBody.success();
        }
        cooperationDao.addApply(userApplyTagDO);
        return ResultBody.success();
    }

    @Transactional
    @Override
    public ResultBody changeUserTag(UserCooperationTagVO userCooperationTagVO) {
        // 删除原来的
        cooperationDao.removeUserTag(userCooperationTagVO.getUserAccountId());
        // 添加新的
        if (!CollectionUtils.isEmpty(userCooperationTagVO.getCooperationTagIds())){
            cooperationDao.batchInsertUserTag(userCooperationTagVO.getUserAccountId(), userCooperationTagVO.getCooperationTagIds());
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody getTagById(Integer id) {
        CooperationTagDO cooperationTagDO = cooperationDao.getTagById(id);
        if (cooperationTagDO == null){
            return ResultBody.success();
        }
        return ResultBody.success(cooperationTagDO.buildCooperationTagVO());
    }
}
