package com.mmc.iuav.user.mq.impl;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.iuav.user.model.vo.UserAccountVO;
import com.mmc.iuav.user.mq.MqProducer;
import com.mmc.iuav.user.mq.RabbitmqConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author: zj
 * @Date: 2023/6/27 15:51
 */
@Slf4j
@Component
public class MqProducerImpl implements MqProducer {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public void sentUserInfoChangedMsg(UserAccountVO userAccountVO) {
        log.info("sentUserInfoChangedMsg:{}", JSONObject.toJSONString(userAccountVO));
        rabbitTemplate.convertAndSend(RabbitmqConstant.USER_INFO_UPDATE_FANOUT_EXCHANGE, "", userAccountVO);
    }
}
