package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.CooperationTagDO;
import com.mmc.iuav.user.entity.UserApplyTagDO;
import com.mmc.iuav.user.entity.UserTagDO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;
import java.util.Set;

/**
 * @author: zj
 * @Date: 2023/5/17 21:20
 */
@Mapper
public interface CooperationDao {
    /**
     * 加盟标签列表
     * @return
     */
    List<CooperationTagDO> listTags();

    /**
     * 加盟申请
     * @param userApplyTagDO
     */
    void addApply(UserApplyTagDO userApplyTagDO);

    /**
     * 根据用户id获取合作申请
     * @param userAccountId
     * @return
     */
    UserApplyTagDO getUserApplyTag(Integer userAccountId);

    /**
     * 修改用户申请
     * @param userApplyTagDO
     */
    void updateUserApplyTag(UserApplyTagDO userApplyTagDO);

    /**
     * 根据用户id查询合作标签信息
     * @param userAccountId
     * @return
     */
    List<CooperationTagDO> listUserCooperationTag(Integer userAccountId);

    /**
     * 用户设置渠道等级
     * @param userTagDO
     */
    void insertUserTag(UserTagDO userTagDO);

    /**
     * 修改用户渠道等级
     * @param userTagDO
     */
    void updateUserTag(UserTagDO userTagDO);

    /**
     * 根据id查询标签信息
     * @param id
     * @return
     */
    CooperationTagDO getTagById(Integer id);

    /**
     * 删除用户原来的标签
     * @param userAccountId
     */
    void removeUserTag(Integer userAccountId);

    /**
     * 添加用户合作加盟标签
     * @param userAccountId
     * @param cooperationTagIds
     */
    void batchInsertUserTag(Integer userAccountId, Set<Integer> cooperationTagIds);

    /**
     * 根据用户id查询用户拥有的合作标签
     * @param uIds
     * @return
     */
    List<CooperationTagDO> listUserCooperationTagByUIds(List<Integer> uIds);
}
