package com.mmc.iuav.user.controller.userpoints.config;

/**
 * @Author small
 * @Date 2023/8/5 16:20
 * @Version 1.0
 */
public enum NumberOfUserPoints {
    //注册
    REGISTER(0, 5),
    //实名认证
    REAL_NAME_AUTHENTICATION(1, 10),
    //飞手认证
    PILOT_CERTIFICATION(2, 20);

    private int code;
    private int message;

    private NumberOfUserPoints(int code, int message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getMessage() {
        return message;
    }

    public void setMessage(int message) {
        this.message = message;
    }

    public static NumberOfUserPoints match(int key) {

        NumberOfUserPoints result = null;

        for (NumberOfUserPoints s : values()) {
            if (s.getCode() == key) {
                result = s;
                break;
            }
        }

        return result;
    }


}
