package com.mmc.iuav.user.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @Author LW
 * @date 2023/7/15 10:10
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class ApplyTagEditVO implements Serializable {
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "网点id")
    private Integer websiteId;
    @ApiModelProperty(value = "标签id")
    private Integer cooperationTagId;
    @ApiModelProperty(value = "网点名称")
    private String name;
    @ApiModelProperty(value = "服务资质")
    private String content;
    @ApiModelProperty(value = "服务评价分数")
    private Integer score;
    @ApiModelProperty(value = "地址信息")
    private String address;
    @ApiModelProperty(value = "纬度")
    private Double lat;
    @ApiModelProperty(value = "经度")
    private Double lon;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "附件")
    private List<AttachmentVO> attachmentList;
    @ApiModelProperty(value = "公司名称")
    private String companyName;
    @ApiModelProperty(value = "品牌名称")
    private String brandName;
    @ApiModelProperty(value = "品牌logo")
    private String brandLogo;
    @ApiModelProperty(value = "营业执照")
    private String licenseImg;


}
