/*
 * Decompiled with CFR 0.152.
 */
package com.piggy.settlement.sdk.util;

import cn.hutool.core.util.StrUtil;
import com.piggy.settlement.sdk.annotation.PiggySig;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;

public class PiggyVerifyUtil {
    public static String getSigStr(String secret, Object params) throws Exception {
        String paramsString = PiggyVerifyUtil.buildMapToSign(params);
        String baseString = secret + paramsString;
        byte[] bytes = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            bytes = md5.digest(baseString.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("\u7b7e\u540d\u8ba1\u7b97md5\u51fa\u9519:" + e.getMessage());
            return null;
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("\u7b7e\u540d\u8ba1\u7b97encode\u51fa\u9519:" + e.getMessage());
            return null;
        }
        StringBuilder sign = new StringBuilder();
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                String hex = Integer.toHexString(bytes[i] & 0xFF);
                if (hex.length() == 1) {
                    sign.append("0");
                }
                sign.append(hex);
            }
        }
        String sigReturn = sign.toString();
        return sigReturn;
    }

    public static String buildMapToSign(Object params) throws UnsupportedEncodingException, IllegalAccessException {
        TreeMap<String, Object> sortMap = new TreeMap<String, Object>();
        Class<?> clz = params.getClass();
        Field[] fields = clz.getDeclaredFields();
        PiggySig annotation = null;
        for (Field field : fields) {
            annotation = field.getAnnotation(PiggySig.class);
            if (null == annotation || !annotation.value()) continue;
            field.setAccessible(true);
            if (null == field.get(params) || StrUtil.hasBlank((CharSequence[])new CharSequence[]{field.get(params).toString()})) continue;
            sortMap.put(field.getName(), field.get(params));
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry e : sortMap.entrySet()) {
            String key = (String)e.getKey();
            String values = "";
            if (null != e.getValue()) {
                values = e.getValue().toString();
            }
            if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{values})) continue;
            if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{builder})) {
                builder.append(String.format("%s=%s", key, URLEncoder.encode(values, "UTF-8")));
                continue;
            }
            builder.append(String.format("&%s=%s", key, URLEncoder.encode(values, "UTF-8")));
        }
        return builder.toString();
    }
}

