package com.mmc.iuav.user.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.mmc.iuav.http.HttpsRequestUtil;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.constant.UserSystemConstant;
import com.mmc.iuav.user.constant.WxConstant;
import com.mmc.iuav.user.model.vo.WxLoginVO;
import com.mmc.iuav.user.service.WxService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author: zj
 * @Date: 2023/5/16 13:44
 */
@Service
public class WxServiceImpl implements WxService {
    @Autowired
    private UserSystemConstant userSystemConstant;

    @Override
    public String appLogin(WxLoginVO wxLoginVO) {
        String url = WxConstant.CODE2_SESSION_URL + "?appid=" + userSystemConstant.getWxAppId() + "&secret=" +
                userSystemConstant.getWxAppSecret() + "&js_code=" + wxLoginVO.getCode() + "&grant_type=" + WxConstant.GRANT_TYPE;
        String data = HttpsRequestUtil.httpsGet(url, null);
        return data;
    }

    @Override
    public String pcLogin(WxLoginVO wxLoginVO) {
        String url = WxConstant.ACCESS_TOKEN_URL + "?appid=" + userSystemConstant.getWxAppId() + "&secret=" + userSystemConstant.getWxAppSecret() +
                "&code=" + wxLoginVO.getCode() + "&grant_type=" + WxConstant.GRANT_TYPE;
        String data = HttpsRequestUtil.httpsGet(url, null);
        return data;
    }

    @Override
    public String getAccessToken() {
        //token有效期为7200s，需要保存起来
        //先从redis中获取accessToken，没有则请求获取
        String accessToken = null;
        if (StringUtils.isBlank(accessToken)){
            String getAccessTokenUrl = "https://api.weixin.qq.com/cgi-bin/token" + "?grant_type=client_credential" + "&appid=" +
                    userSystemConstant.getWxAppId() + "&secret" + userSystemConstant.getWxAppSecret();
            String accessTokenMsg = HttpsRequestUtil.httpsGet(getAccessTokenUrl, null);
            JSONObject tokenResult = JSONObject.parseObject(accessTokenMsg);
            if (accessTokenMsg.indexOf("access_token") == -1) {
                System.out.println("获取用户信息有误：access_token请求失败：" + tokenResult);
                return null;
            }
            accessToken = tokenResult.getString("access_token");
            long expiresIn = tokenResult.getLong("expires_in");
            //保存进redis
            return accessToken;
        }else {
            return accessToken;
        }
    }

    @Override
    public String getSubAccessToken() {
        return null;
    }

    @Override
    public void receiveSubAccountEvents(HttpServletRequest request, HttpServletResponse response) {

    }

    @Override
    public ResultBody sendSubMsg() {
        return null;
    }

    @Override
    public void getUnLimitedQRCode(String path, String scene) {

    }
}
