package com.mmc.iuav.user.service.impl;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.dao.UserServiceDao;
import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.model.dto.UserAccountSimpleDTO;
import com.mmc.iuav.user.model.vo.CompanyAuthVO;
import com.mmc.iuav.user.model.vo.UserAccountVO;
import com.mmc.iuav.user.service.CompanyAuthService;
import com.mmc.iuav.user.service.UserAccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/16 13:48
 */
@Service
public class UserAccountServiceImpl implements UserAccountService {

    @Autowired
    private UserServiceDao userServiceDao;

    @Autowired
    private CompanyAuthService companyAuthService;

    @Override
    public UserAccountVO getUserAccountInfoByUnionId(String unionId) {
        UserAccountDO userAccountDO = userServiceDao.getUserAccountInfoByUnionId(unionId);
        if (userAccountDO != null) {
            return userAccountDO.buildUserAccountVO();
        }
        return null;
    }

    @Override
    public void insertUserAccount(UserAccountDO userAccountDO) {
        userServiceDao.insertUserAccount(userAccountDO);
    }

    @Override
    public UserAccountVO getUserAccountById(Integer userAccountId) {
        UserAccountDO userAccountDO = userServiceDao.getUserAccountById(userAccountId);
        UserAccountVO userAccountVO = userAccountDO.buildUserAccountVO();
        return userAccountVO;
    }

    @Override
    public ResultBody update(UserAccountVO userAccountVO) {
        UserAccountDO userAccountDO = new UserAccountDO(userAccountVO);
        userServiceDao.update(userAccountDO);
        return ResultBody.success();
    }

    @Override
    public UserAccountSimpleDTO getUserSimpleInfo(Integer userAccountId) {
        UserAccountDO userAccountDO = userServiceDao.getUserAccountById(userAccountId);
        UserAccountSimpleDTO userAccountSimpleDTO = userAccountDO.buildUserAccountSimpleDTO();
        CompanyAuthVO companyAuthVO = companyAuthService.getCompanyAuthByUId(userAccountId);
        if (companyAuthVO != null) {
            userAccountSimpleDTO.setCompanyAuthStatus(companyAuthVO.getAuthStatus());
        }else {
            userAccountSimpleDTO.setCompanyAuthStatus(0);
        }
        return userAccountSimpleDTO;
    }

    @Override
    public List<Integer> feignListUserAccountIds(Integer provinceCode, Integer cityCode, Integer districtCode) {
        List<Integer> ids = userServiceDao.listUserAccountIdsByDistrictCode(provinceCode, cityCode, districtCode);
        return ids;
    }
}
