import './index.scss';
import { Col, Form, Row, Select, Table } from 'antd';
import CommonSkuInfo from '~/components/goods/commonSkuInfo';
import { forwardRef, useEffect, useImperativeHandle, useRef, useState } from 'react';
import { RentManageAPI } from '~/api';

type EditableTableProps = Parameters<typeof Table>[0];
type ColumnTypes = Exclude<EditableTableProps['columns'], undefined>;

interface selfProps {
  ref: any;
}

const SkuInfo = forwardRef<any, selfProps>((_props, ref) => {
  const [form] = Form.useForm<{ minLeaseTerm: number; maxLeaseTerm: number }>();
  const commonSkuInfoRef = useRef<any>();

  const [defaultColumns, setDefaultColumns] = useState<
    (ColumnTypes[number] & {
      editable?: boolean;
      dataIndex?: string;
      inputType?: string;
      radioOption?: { name: string; id: number }[];
      rules?: any;
      maxLength?: number;
      children?: any;
      placeholder?: string;
    })[]
  >([
    {
      title: '商品规格',
      align: 'center',
      children: [],
    },
    {
      title: '押金',
      align: 'center',
      editable: true,
      dataIndex: 'skuImage',
    },
  ]);
  const [tableData, setTableData] = useState<any>([]);
  //全部租期下拉
  const [allLeaseTermInfoList, setAllLeaseTermInfoList] = useState<
    {
      label: string;
      value: number;
    }[]
  >([]);
  //  低租期下拉
  const [lowLeaseTermInfoList, setLowLeaseTermInfoList] = useState<
    {
      label: string;
      value: number;
    }[]
  >([]);
  //高租期下拉
  const [upLeaseTermInfoList, setUpLeaseTermInfoList] = useState<
    {
      label: string;
      value: number;
    }[]
  >([]);

  useImperativeHandle(ref, () => ({
    getForm: () => form,
  }));

  const updateTableData = (tableData: any) => {
    setTableData([...tableData]);
  };
  const updateDefaultColumns = (columns: any) => {
    setDefaultColumns([...columns]);
  };

  //租赁-商品-租期信息
  const getLeaseTermInfo = () => {
    RentManageAPI.getLeaseTermInfo().then(({ result }) => {
      if (result) {
        const optionList = result.map((v) => ({ label: v.leaseDate, value: v.id }));
        setLowLeaseTermInfoList(optionList);
        setUpLeaseTermInfoList(optionList);
        setAllLeaseTermInfoList(optionList);
      }
    });
  };
  //最低租期选择
  const lowLeaseTermInfoOnSelect = (value: number) => {
    const upLeaseTermInfoIndex = allLeaseTermInfoList.findIndex((v) => v.value === value);
    if (upLeaseTermInfoIndex !== -1) {
      setUpLeaseTermInfoList(
        allLeaseTermInfoList.slice(upLeaseTermInfoIndex, allLeaseTermInfoList.length),
      );
    }
    if (form.getFieldValue('maxLeaseTerm')) {
      const index = allLeaseTermInfoList.findIndex(
        (v) => v.value === form.getFieldValue('maxLeaseTerm'),
      );
      if (index !== -1) {
        const filterLeaseTermInfo = allLeaseTermInfoList.slice(upLeaseTermInfoIndex, index + 1);
        setDefaultColumns(
          defaultColumns.concat(
            filterLeaseTermInfo.map((v) => ({
              title: v.label,
              align: 'center',
              editable: true,
              dataIndex: v.label,
            })),
          ),
        );
      }
    }
  };
  //  最高租期选择
  const upLeaseTermInfoOnSelect = (value: number) => {
    const lowLeaseTermInfoIndex = allLeaseTermInfoList.findIndex((v) => v.value === value);
    if (lowLeaseTermInfoIndex !== -1) {
      setLowLeaseTermInfoList(allLeaseTermInfoList.slice(0, lowLeaseTermInfoIndex + 1));
    }
    if (form.getFieldValue('minLeaseTerm')) {
      const index = allLeaseTermInfoList.findIndex(
        (v) => v.value === form.getFieldValue('minLeaseTerm'),
      );
      if (index !== -1) {
        const filterLeaseTermInfo = allLeaseTermInfoList.slice(index, lowLeaseTermInfoIndex + 1);
        setDefaultColumns(
          defaultColumns.concat(
            filterLeaseTermInfo.map((v) => ({
              title: v.label,
              align: 'center',
              editable: true,
              dataIndex: v.label,
            })),
          ),
        );
      }
    }
  };

  useEffect(() => {
    getLeaseTermInfo();
  }, []);

  return (
    <div className='sku-info'>
      <div className='sku-info-title'>价格库存信息</div>
      <Row>
        <Col span={1}></Col>
        <Col span={7}>
          <Form wrapperCol={{ span: 18 }} labelCol={{ span: 5 }} form={form}>
            <Form.Item
              label='最低租期'
              name='minLeaseTerm'
              rules={[{ required: true, message: '请选择最低租期' }]}
            >
              <Select
                placeholder='请选择最低租期'
                options={lowLeaseTermInfoList}
                onSelect={lowLeaseTermInfoOnSelect}
              ></Select>
            </Form.Item>
            <Form.Item
              label='最高租期'
              name='maxLeaseTerm'
              rules={[{ required: true, message: '请选择最高租期' }]}
            >
              <Select
                placeholder='请选择最高租期'
                options={upLeaseTermInfoList}
                onSelect={upLeaseTermInfoOnSelect}
              ></Select>
            </Form.Item>
          </Form>
        </Col>
      </Row>
      <Row>
        <Col span={1}></Col>
        <Col span={22}>
          <CommonSkuInfo
            tableData={tableData}
            updateTableData={updateTableData}
            defaultColumns={defaultColumns}
            updateDefaultColumns={updateDefaultColumns}
            ref={commonSkuInfoRef}
          />
        </Col>
      </Row>
    </div>
  );
});
export default SkuInfo;
