import { Form, Input, Radio } from 'antd';
import './index.scss';

type goodsInfoForm = {
  tradeName: string;
  sellingPoint: string;
  level: number;
  shelfStatus: number;
};

const GoodsInfo = () => {
  const qualityList = [
    {
      label: '全新',
      value: 0,
    },
    {
      label: '99新',
      value: 1,
    },
    {
      label: '95新',
      value: 2,
    },
    {
      label: '90新',
      value: 3,
    },
    {
      label: '80新',
      value: 4,
    },
  ];
  const [form] = Form.useForm<goodsInfoForm>();

  return (
    <div className='goods-info'>
      <div className='goods-info-title'>商品信息</div>
      <Form
        labelCol={{ span: 2 }}
        wrapperCol={{ span: 10 }}
        initialValues={{ level: 0 }}
        form={form}
      >
        <Form.Item
          label='商品标题'
          name='tradeName'
          rules={[{ required: true, message: '请输入商品标题' }]}
        >
          <Input placeholder='请输入商品标题' maxLength={30} />
        </Form.Item>
        <Form.Item
          label='商品卖点'
          name='sellingPoint'
          rules={[{ required: true, message: '请输入商品卖点' }]}
        >
          <Input placeholder='请输入商品卖点' maxLength={30} />
        </Form.Item>
        <Form.Item label='商品成新' name='level'>
          <Radio.Group>
            {qualityList.map((v, index) => (
              <Radio value={v.value} key={index}>
                {v.label}
              </Radio>
            ))}
          </Radio.Group>
        </Form.Item>
        <Form.Item label='商品状态' name='shelfStatus'>
          <Radio.Group>
            <Radio value={1}>上架</Radio>
            <Radio value={0}>下架</Radio>
          </Radio.Group>
        </Form.Item>
      </Form>
    </div>
  );
};
export default GoodsInfo;
