import { Button, Table } from 'antd';
import { ArrowDownOutlined, ArrowUpOutlined, PlusOutlined } from '@ant-design/icons';
import { ColumnsType } from 'antd/es/table';
import AddOrEditModal from './components/addOrEditModal';
import { useState } from 'react';

const ServiceCategoryList = () => {
  const tableColumns: ColumnsType<any> = [
    {
      title: '分类名称',
      align: 'center',
    },
    {
      title: '图片',
      align: 'center',
    },
    {
      title: '描述',
      align: 'center',
    },
    {
      title: '业务案例图片',
      align: 'center',
    },
    {
      title: '业务案例视频',
      align: 'center',
    },
    {
      title: '创建时间',
      align: 'center',
    },
    {
      title: '操作',
      align: 'center',
      render: () => (
        <>
          <Button type='link'>新增子分类</Button>
          <Button type='link'>编辑</Button>
          <Button type='link'>删除</Button>
        </>
      ),
    },
  ];
  // const [tableData, setTableData] = useState<any>([{ id: 1 }]);

  const [addOrEditModalShow, setAddOrEditModalShow] = useState<boolean>(false);

  //新增分类弹窗
  const addOrEditModalClick = () => {
    setAddOrEditModalShow(true);
  };
  const addOrEditModalOk = () => {
    setAddOrEditModalShow(false);
  };
  const addOrEditModalCancel = () => {
    setAddOrEditModalShow(false);
  };

  return (
    <div className='service-category-list'>
      <div className='list-operate' style={{ marginBottom: '10px' }}>
        <Button
          type='primary'
          icon={<PlusOutlined />}
          style={{ marginRight: '10px' }}
          onClick={addOrEditModalClick}
        >
          新增分类
        </Button>
        <Button icon={<ArrowUpOutlined />} style={{ marginRight: '10px' }} type='primary'></Button>
        <Button icon={<ArrowDownOutlined />} type='primary'></Button>
      </div>
      <Table columns={tableColumns} bordered rowKey='id' />
      <AddOrEditModal
        open={addOrEditModalShow}
        onOk={addOrEditModalOk}
        onCancel={addOrEditModalCancel}
      />
    </div>
  );
};
export default ServiceCategoryList;
