import { InterFunction, InterItemFunction } from '~/api/interface';

//租赁-类型-新增
export type addType = InterFunction<{ name: string; url: string }, any>;
//租赁-类型-列表
export type getTypeListType = InterItemFunction<any, { id: number; name: string; url: string }[]>;
//租赁-类型-编辑
export type rentTypeEditType = InterFunction<{ name: string; url: string; id: number }, any>;
//租赁-类型-删除
export type rentTypeRemoveType = InterFunction<{ id: number }, any>;

//租赁-品牌-新增
export type rentMakeAddType = InterFunction<{ brandName: string }, any>;
//租赁-品牌-编辑
export type editBrandInfoType = InterFunction<{ brandName: string; id?: number }, any>;
//租赁-品牌-列表
export type listBrandInfoType = InterItemFunction<
  any,
  {
    brandName: string;
    createTime: string;
    id: number;
    modeInfoList: {
      brandInfoId: number;
      id: number;
      modeName: string;
      productTypeId: number;
      tag: string;
    }[];
  }[]
>;

//租赁-型号-新增
export type addRentModeType = InterFunction<
  { modeName: string; productTypeId: number; brandInfoId: number; tag?: string },
  any
>;
//租赁-型号-列表
export type rentModeListType = InterItemFunction<
  { brandInfoId?: number; productTypeId?: number },
  { modeName: string; id: number; brandInfoId: number; productTypeId: number; tag: string }[]
>;

//租赁-商品-新增
export type addRentGoodsType = InterFunction<
  {
    brandInfoId: number;
    deviceModeId: number;
    leasePartsList: { name: string; number: number; price: number }[];
    level: number;
    logisticsCompany: number;
    maxLeaseTerm: number;
    minLeaseTerm: number;
    modeOfDelivery: number;
    priceStock: {
      cashPledge: number;
      maxDaysRental: number;
      ninetyDaysRental: number;
      productSpec: string;
      sevenDaysRental: number;
      showPrice: number;
      skuImage: string;
      stock: number;
      stockOut: number;
      thirtyDaysRental: number;
      threeDaysRental: number;
    }[];
    productDetails: string;
    productParam: string;
    productTypeId: number;
    resourcesList: { type: number; url: string }[];
    returnAddress: number;
    sellingPoint: string;
    shelfStatus: number;
    shipAddress: number;
    tradeName: string;
    specAttrList: { specName: string; specValuesList: { specName: string }[] }[];
  },
  any
>;
//租赁-商品-租期信息
export type leaseTermInfoType = InterFunction<any, { id: number; leaseDate: string }[]>;
