import axios from '~/api/request';
import {
  addCurriculumType,
  addServiceType,
  queryCategoryInfoByType,
  queryCurriculumInfoListType,
  removeCurriculumType,
  serviceType,
  treeCurriculumSkillType,
  updateCurriculumType,
  editServiceType,
  batchUpAndDownWorkServiceType,
  deleteServiceType,
  serviceDetailType,
  exChangeServiceType,
} from '~/api/interface/mallManageType';

export class MallManageAPI {
  // V1.0.1课程视频列表
  static queryCurriculumInfoList: queryCurriculumInfoListType = (params) =>
    axios.post('/release/curriculum/queryCurriculumInfoList', params);
  // V1.0.1新增课程
  static addCurriculum: addCurriculumType = (params) =>
    axios.post('/release/curriculum/addCurriculum', params);
  // V1.0.1修改课程
  static updateCurriculum: updateCurriculumType = (params) =>
    axios.post('/release/curriculum/updateCurriculum', params);
  // V1.0.1课程技能列表
  static treeCurriculumSkill: treeCurriculumSkillType = (params) =>
    axios.get('/release/curriculum/treeCurriculumSkill', { params });
  // V1.0.1删除课程
  static removeCurriculum: removeCurriculumType = (params) =>
    axios.get('/release/curriculum/removeCurriculum', { params });

  // 根据类型获取各个目录及分类信息
  static queryCategoryInfoByType: queryCategoryInfoByType = (params) =>
    axios.get('/pms/classify/queryCategoryInfoByType', { params });
  //  服务-新增
  static addService: addServiceType = (data) =>
    axios.post('/pms/backstage/work/addWorkService', data);
  //服务-编辑
  static editService: editServiceType = (data) =>
    axios.post('/pms/backstage/work/updateWorkService', data);
  //  服务-列表
  static getServiceList: serviceType = (data) =>
    axios.post('/pms/backstage/work/queryServiceManagerList', data);
  //  服务-上下架
  static batchUpAndDownWorkService: batchUpAndDownWorkServiceType = (data) =>
    axios.post('/pms/backstage/work/batchUpAndDownWorkService', data);
  //  服务-删除-批量
  static deleteService: deleteServiceType = (data) =>
    axios.post('/pms/backstage/work/deleteWorkService', data);
  //  服务-详情
  static getServiceDetail: serviceDetailType = (params) =>
    axios.get('/pms/backstage/work/queryWorkService', { params });
  //  服务-上下移
  static exChangeService: exChangeServiceType = (data) =>
    axios.post('/pms/backstage/work/exchange', data);
}
