import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';
// V1.0.1课程视频列表
export type queryCurriculumInfoListType = InterListFunction<
  {
    curriculumName?: string;
    flightSkillsId?: number;
    categoriesId?: number;
    licenseId?: number;
    regionId?: number;
  },
  {
    curriculumDesc: string;
    curriculumName: string;
    detailContent: null;
    flightSkills: number;
    flightSkillsName1: string;
    flightSkillsName2: string;
    free: number;
    id: number;
    price: null;
    supplierName: string;
    surfaceUrl: null;
    videoUrl: string;
    categoriesId: number;
    directoryName: null;
    categoriesName: null;
  }
>;
// V1.0.1新增课程
export type addCurriculumType = InterFunction<
  {
    categoriesId?: number;
    categoriesName?: string;
    curriculumDesc?: string;
    curriculumName?: string;
    detailContent?: string;
    directoryName?: string;
    flightSkills?: number;
    free?: number;
    id?: number | null;
    price?: number;
    supplierName?: string;
    surfaceUrl?: string;
    videoUrl?: string;
  },
  NonNullable<unknown>
>;
// V1.0.1修改课程
export type updateCurriculumType = InterFunction<
  {
    curriculumDesc?: string;
    curriculumName?: string;
    detailContent?: string;
    flightSkills?: number;
    flightSkillsName1?: string;
    flightSkillsName2?: string;
    free?: number;
    id: number | null;
    price?: number;
    supplierName?: string;
    surfaceUrl?: string;
    videoUrl?: string;
  },
  NonNullable<unknown>
>;
// V1.0.1课程技能列表
export type treeCurriculumSkillType = InterFunction<
  any,
  {
    id: number;
    skillsName: string;
    flightSkills: Array<{
      id: number;
      skillsName: string;
      flightSkills: null;
    }>;
  }[]
>;
// V1.0.1删除课程
export type removeCurriculumType = InterFunction<{ id: number }, NonNullable<unknown>>;
// 根据类型获取各个目录及分类信息
export type queryCategoryInfoByType = InterFunction<
  {
    /**
     * 类型:1：作业服务 2：设备 3：培训 4：产品商城
     */
    type: number;
  },
  {
    directoryId: number;
    name: string;
    categoriesInfoListDTO: Array<{
      id: number;
      directoryId: number;
      name: string;
      icon: string;
    }>;
  }[]
>;
//服务-新增
export type addServiceType = InterFunction<
  {
    applicationId: number;
    coverPlan: string;
    displayState: number;
    industryId: number;
    serviceIntroduction?: string;
    serviceName: string;
    shareCard?: string;
    video?: string;
    companyId: number;
  },
  any
>;
//服务-更新
export type editServiceType = InterFunction<
  {
    applicationId?: number;
    coverPlan?: string;
    displayState?: number;
    industryId?: number;
    serviceIntroduction?: string;
    serviceName?: string;
    shareCard?: string;
    video?: string;
    id: number;
    companyId: number;
  },
  any
>;
//服务-列表
export type serviceType = InterItemFunction<
  { applicationId?: number; industryId?: number; serviceName?: string; displayState?: number },
  {
    applicationName: string;
    serviceName: string;
    industryName: string;
    coverPlan: string;
    shareCard: string;
    video: string;
    serviceIntroduction: string;
    displayState: number;
    applicationId: number;
    industryId: number;
    id: number;
    companyId: number;
  }[]
>;
//服务-上下架-批量
export type batchUpAndDownWorkServiceType = InterFunction<
  { displayState: number; ids: number[] },
  any
>;
//服务-删除-批量
export type deleteServiceType = InterFunction<number[], any>;
//服务-详情
export type serviceDetailType = InterFunction<
  { id: number },
  {
    applicationName: string;
    serviceName: string;
    industryName: string;
    coverPlan: string;
    shareCard: string;
    video: string;
    serviceIntroduction: string;
    displayState: number;
    applicationId: number;
    industryId: number;
    id: number;
    companyName: string;
  }
>;
