import { useEffect, useState } from 'react';
import { useNavigate, useSearchParams } from 'react-router-dom';
import { Button } from 'antd';
import './index.scss';
import DetailPurchaser from '~/pages/orderManage/equipmentOrder/comp/detailPurchaser';
import DetailInformation from '~/pages/orderManage/equipmentOrder/comp/detailInformation';
import { OrderManageAPI } from '~/api';
import { InterDataType } from '~/api/interface';
import { rentOrderDetailType, rentOrderDictType } from '~/api/interface/orderManageType';

// 接口返回的类型
type DataType = InterDataType<rentOrderDetailType>;
// 订单状态返回类型
type OrderStatusType = InterDataType<rentOrderDictType>;

function EquipmentOrderDetail() {
  // 路由钩子
  const navigate = useNavigate();
  // 参数钩子
  const [searchParams] = useSearchParams();
  // 订单id
  // const [orderId, setOrderId] = useState<number>(0);
  // 订单状态字典
  const [orderStatusList, setOrderStatusList] = useState<OrderStatusType>([]);

  // 返回上一页
  const handleBack = () => {
    navigate(-1);
  };
  // 订单详情
  const [orderDetail, setOrderDetail] = useState<DataType>(null!);
  // 获取订单详情
  const getOrderDetail = (id: number) => {
    OrderManageAPI.getRentOrderDetail({
      id,
    }).then(({ result }) => {
      if (result) {
        setOrderDetail(result);
      }
    });
  };
  // 获取订单状态
  const getOrderStatus = () => {
    OrderManageAPI.getRentOrderDict().then(({ result }) => {
      setOrderStatusList(result || []);
    });
  };

  // componentDidMount
  useEffect(() => {
    // setOrderId(Number(searchParams.get('id') || 0));
    getOrderDetail(Number(searchParams.get('id') || 0));
    getOrderStatus();
  }, []);
  return (
    <div className='order-detail'>
      <div className='order-head'>
        <Button type='primary' onClick={() => handleBack()}>
          返回
        </Button>
      </div>
      <div className='detail-wrap'>
        <DetailPurchaser detail={orderDetail} />
        <DetailInformation detail={orderDetail} orderStatusList={orderStatusList} />
      </div>
    </div>
  );
}

export default EquipmentOrderDetail;
