import React, { useEffect, useState } from 'react';
import { Button, Steps } from 'antd';
import { mallOrderDetailType } from '~/api/interface/orderManageType';
import { InterDataType } from '~/api/interface';
import { OrderManageAPI } from '~/api';
import LogisticsStepModal from '~/components/order/productOrder/logisticsStepModal';

// 接口返回的类型
type DataType = InterDataType<mallOrderDetailType>;
// 参数类型
type PropsType = {
  detail: DataType | undefined;
};
const DetailDelivery: React.FC<PropsType> = ({ detail }) => {
  const [logisticsStepModalShow, setLogisticsStepModalShow] = useState<boolean>(false);
  const [listExpressInfo, setListExpressInfo] = useState<{ label: string; value: string }[]>([]);
  //获取物流公司列表
  const getExpressList = () => {
    OrderManageAPI.listExpressInfo().then(({ result }) => {
      setListExpressInfo(result?.map((v) => ({ label: v.exName, value: v.exCode })) || []);
    });
  };

  const showStepModal = () => {
    setLogisticsStepModalShow(true);
  };
  const logisticsStepModalCancel = () => {
    setLogisticsStepModalShow(false);
  };

  useEffect(() => {
    getExpressList();
  }, []);

  return (
    <div className='detail-delivery detail-half'>
      <div className='detail-title'>发货信息</div>
      <div className='detail-text'>收货人：{detail?.uavOrderExpressDTO?.takeName}</div>
      <div className='detail-text'>手机号：{detail?.uavOrderExpressDTO?.takePhone}</div>
      <div className='detail-text'>
        收货地址：
        {(detail?.uavOrderExpressDTO.takeRegion.split('/').join('') || '') +
          detail?.uavOrderExpressDTO.takeAddress}
      </div>
      {detail?.uavOrderExpressDTO?.sendExpCode && (
        <>
          <div className='detail-text'>物流单号：{detail?.uavOrderExpressDTO?.sendExpNo}</div>
          <div className='detail-text'>
            物流公司：
            {
              listExpressInfo.find((v) => v.value === detail?.uavOrderExpressDTO?.sendExpCode)
                ?.label
            }
          </div>
          <div className='detail-text' style={{ display: 'flex' }}>
            <span>物流进度：</span>
            <div>
              <Steps
                direction='vertical'
                current={0}
                progressDot
                items={[
                  {
                    title: detail?.kdnExpDTO?.traces?.[0].acceptStation,
                    description: detail?.kdnExpDTO?.traces?.[0].acceptTime,
                  },
                  {
                    title: `送至${
                      detail?.uavOrderExpressDTO?.takeRegion.split('/').join('') +
                      detail?.uavOrderExpressDTO?.takeAddress
                    }`,
                  },
                ]}
              />
            </div>
            <div>
              <Button type='link' onClick={showStepModal}>
                查看详情
              </Button>
            </div>
          </div>
        </>
      )}
      <LogisticsStepModal
        open={logisticsStepModalShow}
        onCancel={logisticsStepModalCancel}
        logisticsStep={detail?.kdnExpDTO}
      />
    </div>
  );
};

export default DetailDelivery;
