import React, { FC } from 'react';
import { Modal, ModalProps, Table } from 'antd';
import { ColumnsType } from 'antd/es/table';
import { InterDataType } from '~/api/interface';
import { industrySpecDetailType } from '~/api/interface/industryManageType';
//方案规格详情返回类型
type productInventoryListType = InterDataType<industrySpecDetailType>['productInventoryList'];

interface PropsType {
  data: productInventoryListType;
  onCancel: () => void;
}

const ProductListModal: FC<ModalProps & PropsType> = ({ open, onCancel, data }) => {
  // 表格结构
  const columns: ColumnsType<productInventoryListType[0]> = [
    {
      title: '序号',
      align: 'center',
      width: '50px',
      render: (_text: string, _record: productInventoryListType[0], index: number) => {
        return index + 1;
      },
    },
    {
      title: '产品名称',
      dataIndex: 'productName',
      align: 'center',
      width: '100px',
      render: (_text: string, record: productInventoryListType[0]) => {
        return record.productSku.productName;
      },
    },
    {
      title: '产品类型',
      dataIndex: 'typeName',
      align: 'center',
      width: '100px',
      render: (_text: string, record: productInventoryListType[0]) => {
        return record.productSku.goodsTypeId;
      },
    },
    {
      title: '型号',
      dataIndex: 'model',
      align: 'center',
      width: '100px',
      render: (_text: string, record: productInventoryListType[0]) => {
        return record.productSku.model;
      },
    },
    {
      title: '产品品牌',
      dataIndex: 'productBrand',
      align: 'center',
      width: '100px',
      render: (_text: string, record: productInventoryListType[0]) => {
        return record.productSku.productName;
      },
    },
    {
      title: '产品规格',
      // align: "left",
      width: '200px',
      render: (_text: string, record) => {
        if (record.select === 0) {
          return '不指定';
        }
        return record.productSpecList.map((i: any, index: number) => (
          <div key={index}>
            {i.specName}({i.partNo})
          </div>
        ));
      },
      onHeaderCell: () => {
        return {
          style: {
            textAlign: 'center',
          },
        };
      },
    },
  ];
  // 关闭
  const onClose = () => {
    onCancel();
  };
  return (
    <Modal open={open} title='产品清单' onCancel={onClose} destroyOnClose footer={null} width={800}>
      <Table
        size='small'
        dataSource={data}
        columns={columns}
        rowKey='id'
        style={{ width: '100%' }}
        bordered
        pagination={false}
      />
    </Modal>
  );
};
export default ProductListModal;
