import axios from '../request';
import {
  addPrimaryCategoryType,
  addSubCategoryType,
  categoryDetailsType,
  categoryListRespType,
  categoryListType,
  categoryRelevantType,
  deletePrimaryCategoryType,
  deleteSubCategoryType,
  directoryListType,
  directoryPageListType,
  exchangeType,
  industryInsertType,
  industryListPagesType,
  industryRemoveType,
  industryUpdateType,
  inspectionDetailType,
  inspectionInsertType,
  inspectionRemoveType,
  inspectionTagDeleteType,
  inspectionTagInsertType,
  inspectionTagUpdateType,
  inspectionUpdateType,
  listByInspectionIdType,
  updatePrimaryCategoryType,
  updateSubCategoryType,
} from '~/api/interface/categoryManage';

export class CategoryManageAPI {
  // 分类目录
  static directoryList = (params: { pageNo: number; pageSize: number; type?: any }) => {
    return axios.get('pms/classify/directoryList', {
      params,
    });
  };
  // 分类目录(类型)
  static directoryListClone: directoryPageListType = (params) => {
    return axios.get('pms/classify/directoryList', {
      params,
    });
  };
  // 分类目录-不分页(类型)
  static getDirectoryListClone: directoryListType = (params) => {
    return axios.get('/pms/classify/getDirectoryList', { params });
  };
  // 新增或编辑目录
  static addOrEditDirectory = (data: {
    id?: number;
    directoryName: string;
    type: number;
    show: number[];
  }) => {
    return axios.post('/pms/classify/addOrEditDirectory', data);
  };

  // 删除目录
  static removeDirectory = (id: number) => {
    return axios.get('/pms/classify/removeDirectory', { params: { id } });
  };

  // 分类新增
  static addClassification = (data: object): any => {
    return axios.post('/pms/classify/addClassification', data);
  };

  // 分类列表
  static getClassificationList = (data: object): any => {
    return axios.post(`/pms/classify/getClassificationList`, data);
  };

  static getCategoryList: categoryListType = (data) => {
    return axios.post('/pms/classify/getClassificationList', data);
  };

  // 分类修改
  static updateClassification = (data: object): any => {
    return axios.post('/pms/classify/updateClassification', data);
  };

  // 删除分类
  static deleteRelevantBusiness = (params: object): any => {
    return axios.get('/pms/classify/deleteRelevantBusiness', { params });
  };

  // 分类上下移动
  static exchangeSortType = (params: object): any => {
    return axios.get('/pms/classify/exchangeSortType', { params });
  };

  // 分类详情
  static getGoodsTypeDetail: categoryDetailsType = (params) => {
    return axios.get('/pms/classify/getClassifyDetails', { params });
  };

  // 分类详情-安全编码开发修改
  // static updateIsShowCode = (params: Pick<GoodsInfo, 'goodsId' | 'showCode'>) => {
  //   return axios.get('uavgoods/appgoods/updateIsShowCode', { params });
  // };

  // 分类详情-商品排序
  static exchangeGoodsInfo = (firstId: number, secondId: number) => {
    return axios.get('uavgoods/mgoods/exchangeGoodsInfo', {
      params: { firstId, secondId },
    });
  };

  // 分类详情-图片上传
  static cateGoryDetailUpload = (data: FormData) => {
    return axios.post('ossservlet/upload/imgOss', data);
  };
  // 行业分享码
  static getAppletQRCode(params: { page: string; scene: string }) {
    return axios.get('malluser/wechat/getAppletQRCode', { params });
  }
  //  分类关联列表
  static getRelevantBusiness: categoryRelevantType = (params) => {
    return axios.get('/pms/classify/queryRelevantBusiness', { params });
  };

  //  分类管理-分类列表（新）
  static getCategoryRespList: categoryListRespType = (data) =>
    axios.post('/pms/category/categoryList', data);
  //  分类管理-1级分类新增（新）
  static addPrimaryCategory: addPrimaryCategoryType = (data) =>
    axios.post('/pms/category/addPrimaryCategory', data);
  //  分类管理-1级分类编辑（新）
  static updatePrimaryCategory: updatePrimaryCategoryType = (data) =>
    axios.post('/pms/category/updatePrimaryCategory', data);
  //  分类管理-1级分类删除（新）
  static deletePrimaryCategory: deletePrimaryCategoryType = (params) =>
    axios.get('/pms/category/deletePrimaryCategory', { params });
  //分类管理-1级分类交换顺序
  static exchangeCategory: exchangeType = (data) => axios.post('/pms/category/exchange', data);
  //  分类管理-2级分类新增（新）
  static addSubCategory: addSubCategoryType = (data) =>
    axios.post('/pms/category/addSubCategory', data);
  //  分类管理-2级分类编辑（新）
  static updateSubCategory: updateSubCategoryType = (data) =>
    axios.post('/pms/category/updateSubCategory', data);
  //  分类管理-2级分类删除（新）
  static deleteSubCategory: deleteSubCategoryType = (params) =>
    axios.get('/pms/category/deleteSubCategory', { params });
  // 一级行业列表
  static industryListPages: industryListPagesType = (params) =>
    axios.post('/pms/industry/listPages', params);
  // 新增行业
  static industryInsert: industryInsertType = (params) =>
    axios.post('/pms/industry/insert', params);
  // 修改行业
  static industryUpdate: industryUpdateType = (params) =>
    axios.post('/pms/industry/update', params);
  // 新增服务
  static inspectionInsert: inspectionInsertType = (params) =>
    axios.post('/pms/inspection/insert', params);
  // 修改服务
  static inspectionUpdate: inspectionUpdateType = (params) =>
    axios.post('/pms/inspection/update', params);
  // 删除行业
  static industryRemove: industryRemoveType = (params) =>
    axios.get('/pms/industry/remove', { params });
  // 删除服务
  static inspectionRemove: inspectionRemoveType = (params) =>
    axios.get('/pms/inspection/remove', { params });
  // 根据服务id查询标签列表
  static listByInspectionId: listByInspectionIdType = (params) =>
    axios.get('/pms/inspection-tag/listByInspectionId', { params });
  // 新增服务标签
  static inspectionTagInsert: inspectionTagInsertType = (params) =>
    axios.post('/pms/inspection-tag/insert', params);
  // 修改服务标签
  static inspectionTagUpdate: inspectionTagUpdateType = (params) =>
    axios.post('/pms/inspection-tag/update', params);
  // 删除服务标签
  static inspectionTagDelete: inspectionTagDeleteType = (params) =>
    axios.get('/pms/inspection-tag/delete', { params });
  // 服务详情
  static inspectionDetail: inspectionDetailType = (params) =>
    axios.get('/pms/inspection/detail', { params });
}
