import { InterFunction, InterListFunction } from '~/api/interface';

// 提现列表
export type listPageWithdrawalApplyType = InterListFunction<
  {
    /**
     * 状态: 0提现申请中 1提现成功 2提现失败
     */
    tradeStatus?: string;
    /**
     * 结束时间
     */
    endTime?: string;
    /**
     * 关键字
     */
    keyword?: string;
    /**
     * 通道标识-微信(wechat)-支付宝(alipay)-银行卡(bank_card)
     */
    settleType?: string;
    /**
     * 开始时间
     */
    startTime?: string;
  },
  {
    /**
     * 申请金额
     */
    applyAmt?: number;
    /**
     * 状态: 0平台处理中 1提现成功 2提现失败
     */
    applyStatus?: number;
    /**
     * 开户银行-支行名称
     */
    bankName?: string;
    /**
     * 创建时间
     */
    createTime?: Date;
    /**
     * 开户人
     */
    empName?: string;
    /**
     * id
     */
    id: number;
    /**
     * 流水编号
     */
    outerTradeNo?: string;
    /**
     * 收款账号
     */
    payAccount?: string;
    /**
     * 手机号
     */
    phoneNum?: string;
    /**
     * 备注
     */
    remark?: string;
    /**
     * 提现方式-微信(wechat)-支付宝(alipay)-银行卡(bank_card)
     */
    settleType: string;
    /**
     * 处理信息
     */
    tradeResult?: string;
    tradeStatus: string;
    /**
     * 申请人的用户ID
     */
    userAccountId?: number;
  }
>;

//提现审批
export type approveWithdrawalApplyType = InterFunction<
  {
    /**
     * 状态: 0提现申请中 1审批通过 2审批未通过
     */
    applyStatus: number;
    /**
     * 申请单ID
     */
    id: number;
    /**
     * 备注
     */
    remark?: string;
  },
  any
>;
// 提现数据统计
export type statisticsType = InterFunction<
  any,
  {
    cashPoolAmount: number;
    totalWithdrawAmt: number;
  }
>;
