import { InterFunction, InterItemFunction, InterListFunction } from '~/api/interface';

// 客户列表
export type listAppUserType = InterListFunction<
  {
    companyAuthStatus?: number;
    endTime?: string;
    keyword?: string;
    phoneNum?: string;
    startTime?: string;
    realAuthStatus?: number;
    xzAuthStatus?: number;
  },
  {
    id: number;
    accountType: number;
    uid: string;
    accountNo: null;
    phoneNum: string;
    userName: null;
    nickName: string;
    userImg: string;
    userSex: number;
    email: null;
    source: null;
    accountStatus: number;
    remark: null;
    portType: number;
    createTime: string;
    companyAuthStatus: number;
    cooperationTagId: number;
    companyName: null;
    realAuthStatus: number;
    tagName: null;
    cooperationTagVOS: {
      createTime: string;
      id: number;
      tagDescription: string;
      tagImg: string;
      tagName: string;
      tagRequire: string;
    }[];
    userRcdVO: {
      createTime: string;
      id: number;
      rcdNickname: string;
      rcdUserId: number;
      rcdUserName: string;
      remark: string;
      userAccountId: number;
    };
    inviteCount: number;
    xzAuthStatus: number;
  }
>;
// 加盟标签列表
export type CompanyListTag = InterFunction<
  NonNullable<unknown>,
  {
    id: number;
    tagName: string;
    tagImg: null;
    tagDescription: string;
    createTime: string;
  }[]
>;
// 修改用户信息
export type userAccountUpdateType = InterFunction<
  {
    accountNo?: string;
    accountStatus?: number;
    accountType?: number;
    companyAuthStatus?: number;
    companyName?: string;
    cooperationTagId?: number;
    createTime?: string;
    email?: string;
    id: number;
    nickName?: string;
    phoneNum?: string;
    portType?: number;
    remark?: string;
    source?: number;
    tagName?: string;
    uid?: string;
    userImg?: string;
    userName?: string;
    userSex?: number;
  },
  NonNullable<unknown>
>;
// 后台设置小程序用户标签
export type changeUserTagType = InterFunction<
  {
    cooperationTagId: number;
    userAccountId: number;
  },
  NonNullable<unknown>
>;
// 后台设置小程序用户标签
export type changeUserTagNew = InterFunction<
  {
    cooperationTagIds: number[];
    userAccountId: number;
  },
  NonNullable<unknown>
>;
// 加盟标签列表
export type cooperationListTag = InterFunction<
  NonNullable<unknown>,
  {
    createTime: string;
    id: number;
    tagDescription: string;
    tagImg: string;
    tagName: string;
  }[]
>;
// 后台申请列表
export type listUserApplyTag = InterListFunction<
  {
    applyStatus?: number;
    cooperationTagId?: number;
    companyName?: string;
    endTime?: string;
    startTime?: string;
  },
  {
    applyName: string;
    applyPhone: string;
    applyTime: string;
    approvalStatus: number;
    attachmentList: Array<{
      type: number;
      url: string;
    }>;
    companyName: string;
    content: string;
    cooperationTagId: number;
    cooperationTagName: string;
    id: number;
    remark: string;
    score: number;
    userAccountId: number;
    orderNo: string;
    signStatus: number;
  }
>;
// 审批详情
export type applyTagDetails = InterFunction<
  {
    id?: number;
    userAccountId?: number;
  },
  {
    attachmentList: {
      /**
       * 附件类型：0：图片 1：文件
       */
      type: number;
      url: string;
    }[];
    companyName: string;
    creditCode: string;
    licenseImg: string;
    remark: string;
  }
>;
// 审批
export type approvalApplyTag = InterFunction<
  {
    id: number;
    status: boolean;
  },
  NonNullable<unknown>
>;
// 强制删除
export type deleteApplyTag = InterFunction<
  {
    id: number;
  },
  NonNullable<unknown>
>;
// 后台-编辑详情信息
export type editUserApplyTagDetails = InterFunction<
  {
    id: number;
  },
  {
    address: string;
    content: string;
    cooperationTagId: number;
    id: number;
    lat: number;
    lon: number;
    name: string;
    score: number;
    licenseImg: string;
    remark: string;
    attachmentList?: { userApplyTagId: number; url: string; type: number }[];
    brandLogo: string;
    contractNo?: string;
    signStatus: number;
  }
>;
// 后台-编辑服务商信息
export type editUserApplyTag = InterFunction<
  {
    address?: string;
    content?: string;
    cooperationTagId?: number;
    id: number;
    lat?: number;
    lon?: number;
    name?: string;
    score?: number;
  },
  NonNullable<unknown>
>;
// 裂变-邀请列表
export type listUserRcdType = InterListFunction<
  {
    userAccountId: number;
  },
  {
    accountStatus: null;
    accountType: null;
    companyAuthStatus: number;
    companyName: null;
    cooperationTagVOS: null;
    createTime: string;
    deleted: null;
    email: null;
    id: number;
    inviteCount: null;
    nickName: string;
    phoneNum: string;
    portType: null;
    remark: null;
    source: null;
    uid: null;
    userImg: string;
    userName: null;
    userRcdVO: null;
    userSex: null;
  }
>;

//实名认证列表返回类型
export type listAuthPageType = InterItemFunction<
  { keyword?: string },
  {
    id: number;
    nickName: string;
    phoneNum: string;
    uid: string;
    userName: string;
    createTime: string;
    remark: string;
  }[]
>;
//实名认证详情返回类型
export type authDetailType = InterFunction<
  { id: number },
  {
    backIdImg: string;
    checkStatus: number;
    frontIdImg: string;
    id: number;
    idNumber: string;
    userAccountId: number;
    userName: string;
  }
>;
//实名认证-更新备注
export type authRemarkType = InterFunction<{ id: number; remark: string }, any>;

// 商家列表-数据统计
export type listAppUserCountType = InterFunction<
  any,
  {
    failAuditSum: number;
    passAuditSum: number;
    unAuditedSum: number;
  }
>;
