import React, { useEffect } from 'react';
import { InterListType, InterReqType } from '~/api/interface';
import { insertBAccountType, listBAccountPageType } from '~/api/interface/systemManageType';
import { Form, Input, message, Modal } from 'antd';
import { SystemManageAPI } from '~/api';

// 列表的类型
type TableType = InterListType<listBAccountPageType>;
// 请求的表单类型
type ReqType = InterReqType<insertBAccountType>;
// 传参类型
interface propType {
  title: string;
  open: boolean;
  closed: any;
  data?: TableType[0];
}
const ChangeModal: React.FC<propType> = (props) => {
  // 参数
  const { title, open, closed, data } = props;
  /// 表单钩子
  const [form] = Form.useForm<ReqType>();
  // 关闭弹窗
  const handleCancel = () => {
    form.resetFields();
    closed();
  };
  // 确认事件
  const handleOk = () => {
    form
      .validateFields()
      .then(async (values) => {
        await handleSubmit(values);
      })
      .catch((err) => {
        message
          .warning({
            content: err.errorFields[0].errors[0],
          })
          .then();
      });
  };
  // 提交事件
  const handleSubmit = async (values: ReqType) => {
    const res = await SystemManageAPI.updatePassword({
      ...values,
      id: Number(data?.id),
    });
    if (res && res.code === '200') {
      message.success('操作成功');
      handleCancel();
    }
  };
  // componentDidMount
  useEffect(() => {
    if (!open) return;
    if (!data) return;
    form.setFieldsValue(data);
    // console.log('data --->', data);
  }, [open]);
  return (
    <Modal open={open} title={title} onCancel={handleCancel} onOk={handleOk} destroyOnClose>
      <Form name='addForm' form={form} labelAlign='right'>
        <Form.Item
          label='账号'
          labelCol={{ span: 4 }}
          wrapperCol={{ span: 18 }}
          rules={[{ required: true, message: '请输入账号' }]}
          name='accountNo'
        >
          {data?.accountNo}
        </Form.Item>
        <Form.Item
          label='密码'
          labelCol={{ span: 4 }}
          wrapperCol={{ span: 18 }}
          rules={[{ required: true, message: '请输入密码' }]}
          name='passWord'
        >
          <Input.Password
            placeholder='请输入密码'
            maxLength={20}
            autoComplete='new-password'
            allowClear
          />
        </Form.Item>
        <Form.Item
          label='确认密码'
          labelCol={{ span: 4 }}
          wrapperCol={{ span: 18 }}
          name='alertPwd'
          rules={[
            { required: true, message: '请输入密码' },
            // 判断密码是否相同
            ({ getFieldValue }) => ({
              validator(_, value) {
                if (!value || getFieldValue('passWord') === value) {
                  return Promise.resolve();
                }
                return Promise.reject(new Error('两次密码不一致'));
              },
            }),
          ]}
        >
          <Input.Password
            placeholder='请再次输入密码'
            maxLength={20}
            autoComplete='new-password'
            allowClear
          />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default ChangeModal;
