import { useSearchParams } from 'react-router-dom';
import { useEffect, useState } from 'react';
import { SystemManageAPI } from '~/api';
import { InterDataType } from '~/api/interface';
import { getCompanyInfoByIdType } from '~/api/interface/systemManageType';
import { Button, Descriptions, Table } from 'antd';
import './index.scss';

//单位详情-返回类型
type companyDetailType = InterDataType<getCompanyInfoByIdType>;
const CompanyDetail = () => {
  const [searchParams] = useSearchParams();
  const [companyId, setCompanyId] = useState<number>(-1);
  const [companyDetail, setCompanyDetail] = useState<companyDetailType>();

  //单位详情
  const getCompanyDetailInfo = (id: number) => {
    SystemManageAPI.getCompanyInfoById({ id }).then(({ result }) => {
      setCompanyDetail(result);
    });
  };

  useEffect(() => {
    setCompanyId(Number(searchParams.get('id')));
    getCompanyDetailInfo(Number(searchParams.get('id')));
  }, []);

  return (
    <div className='company-detail'>
      <div className='company-detail-info'>
        <Descriptions title='基本信息' bordered column={4}>
          <Descriptions.Item label='单位名称'>{companyDetail?.companyName}</Descriptions.Item>
          <Descriptions.Item label='详细地址'>{companyDetail?.address}</Descriptions.Item>
          <Descriptions.Item label='联系人'>
            {companyDetail?.companyUserName || ''}
          </Descriptions.Item>
          <Descriptions.Item label='联系电话'>{companyDetail?.phoneNum || ''}</Descriptions.Item>
        </Descriptions>
      </div>
      <div className='company-detail-people'>
        <div className='company-detail-people-title'>成员信息</div>
        <Table bordered />
      </div>
      <div className='company-detail-operate'>
        <Button type='primary'>返回</Button>
      </div>
    </div>
  );
};
export default CompanyDetail;
