import { InterFunction } from '~/api/interface';

// 数据看板-用户概况
export type userReportDataType = InterFunction<
  any,
  {
    /**
     * 飞手认证数量
     */
    dronePilotCount?: number;
    /**
     * 实名认证数量
     */
    realNameCount?: number;
    /**
     * 用户数量
     */
    userCount?: number;
    /**
     * 昨日活跃用户数量
     */
    yesterdayActiveUserCount?: number;
    /**
     * 昨日新增用户数量
     */
    yesterdayAddUserCount?: number;
  }
>;
//数据看板-信息发布
export type releaseReportDataType = InterFunction<
  any,
  {
    /**
     * 订单发布数量
     */
    orderReleaseCount?: number;
    /**
     * 帖子发布数量
     */
    postsReleaseCount?: number;
    /**
     * 信息发布总数
     */
    releaseCount?: number;
    /**
     * 话题发布数量
     */
    topicReleaseCount?: number;
  }
>;
// 数据看板-加盟信息
export type userJoinReportDataType = InterFunction<
  any,
  {
    /**
     * 品牌商
     */
    brandStore: number;
    /**
     * 入驻商家总数
     */
    joinStoreCount: number;
    /**
     * 出租商品
     */
    leaseProduct: number;
    /**
     * 租赁商
     */
    leaseStore: number;
    /**
     * 在线课程
     */
    onlineCourse: number;
    /**
     * 维修商
     */
    repairStore: number;
    /**
     * 销售商品
     */
    saleProduct: number;
    /**
     * 服务商品
     */
    serviceProduct: number;
    /**
     * 服务商
     */
    serviceStore: number;
    /**
     * 培训机构
     */
    trainingInstitution: number;
  }
>;
// 数据看板-订单数据
export type orderReportDataType = InterFunction<
  any,
  {
    /**
     * 商品租赁交易总额
     */
    leaseGMV: number;
    /**
     * 商品租赁订单总数
     */
    leaseOrderCount: number;
    /**
     * 商城售卖交易总额
     */
    saleGMV: number;
    /**
     * 商城售卖订单总数
     */
    saleOrderCount: number;
    /**
     * 服务订单交易总额
     */
    serviceGMV: number;
    /**
     * 服务订单订单总数
     */
    serviceOrderCount: number;
    /**
     * 交易总额
     */
    totalGMV: number;
  }
>;
