import { Form, Input, Modal, ModalProps, Select } from 'antd';
import { FC, useEffect, useState } from 'react';
import { InterDataType, InterReqType } from '~/api/interface';
import { addRentModeType, getTypeListType } from '~/api/interface/rentManageType';
import { RentManageAPI } from '~/api';

interface selfProps {
  onOk: () => void;
  onCancel: () => void;
}
//型号新增参数类型
type addRentParameterType = Exclude<InterReqType<addRentModeType>, undefined>;
//类型类别返回类型
type rentTypeListType = InterDataType<getTypeListType>['list'];

const AddOrEditRentModeModal: FC<ModalProps & selfProps> = ({ open, onOk, onCancel }) => {
  const [form] = Form.useForm<addRentParameterType>();
  const [rentTypeList, setRentTypeList] = useState<rentTypeListType>([]);

  const handleOk = () => {
    onOk();
  };
  const handleCancel = () => {
    onCancel();
  };
  //获取类型列表
  const getRentTypeList = () => {
    RentManageAPI.getTypeList({ pageNo: 1, pageSize: 99999 }).then(({ result }) => {
      setRentTypeList(result.list || []);
    });
  };

  useEffect(() => {
    getRentTypeList();
  }, []);

  return (
    <Modal open={open} onOk={handleOk} onCancel={handleCancel} title='新增型号'>
      <Form form={form}>
        <Form.Item label='所属类别'>
          <Select placeholder='请选择所属类别'>
            {rentTypeList.map((v) => (
              <Select.Option key={v.id} value={v.id}>
                {v.name}
              </Select.Option>
            ))}
          </Select>
        </Form.Item>
        <Form.Item label='型号名称'>
          <Input placeholder='请输入型号名称' />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default AddOrEditRentModeModal;
