import {
  addRentModeType,
  addType,
  editBrandInfoType,
  getTypeListType,
  listBrandInfoType,
  rentMakeAddType,
  rentTypeEditType,
  rentTypeRemoveType,
} from '~/api/interface/rentManageType';
import axios from '../request';

export class RentManageAPI {
  //租赁-类型-新增
  static addTypeReq: addType = (data) => axios.post('/pms/attribute/addType', data);
  //租赁-类型-列表
  static getTypeList: getTypeListType = (params) =>
    axios.get('/pms/attribute/typeList', { params });
  //  租赁-类型-编辑
  static editTypeReq: rentTypeEditType = (data) => axios.post('/pms/attribute/editType', data);
  //  租赁-类型-删除
  static rentTypeRemove: rentTypeRemoveType = (params) =>
    axios.get('/pms/attribute/removeType', { params });

  //  租赁-品牌-新增
  static addBrandInfo: rentMakeAddType = (params) =>
    axios.get('/pms/brand/addBrandInfo', { params });
  //  租赁-品牌-编辑
  static editBrandInfo: editBrandInfoType = (params) =>
    axios.get('/pms/brand/editBrandInfo', { params });
  //   租赁-品牌-列表
  static getListBrandInfo: listBrandInfoType = (params) =>
    axios.get('/pms/brand/listBrandInfo', { params });

  //  租赁-型号-新增
  static addRentMode: addRentModeType = (data) => axios.post('/pms/brand/addMode', data);
}
