import { InterFunction, InterListFunction } from '~/api/interface';

// 客户列表
export type listAppUserType = InterListFunction<
  {
    companyAuthStatus?: number;
    endTime?: string;
    keyword?: string;
    phoneNum?: string;
    startTime?: string;
  },
  {
    id: number;
    accountType: number;
    uid: string;
    accountNo: null;
    phoneNum: string;
    userName: null;
    nickName: string;
    userImg: string;
    userSex: number;
    email: null;
    source: null;
    accountStatus: number;
    remark: null;
    portType: number;
    createTime: string;
    companyAuthStatus: number;
    cooperationTagId: number;
    companyName: null;
    tagName: null;
  }
>;
// 加盟标签列表
export type CompanyListTag = InterFunction<
  NonNullable<unknown>,
  {
    id: number;
    tagName: string;
    tagImg: null;
    tagDescription: string;
    createTime: string;
  }[]
>;
// 修改用户信息
export type userAccountUpdateType = InterFunction<
  {
    accountNo?: string;
    accountStatus?: number;
    accountType?: number;
    companyAuthStatus?: number;
    companyName?: string;
    cooperationTagId?: number;
    createTime?: string;
    email?: string;
    id: number;
    nickName?: string;
    phoneNum?: string;
    portType?: number;
    remark?: string;
    source?: number;
    tagName?: string;
    uid?: string;
    userImg?: string;
    userName?: string;
    userSex?: number;
  },
  NonNullable<unknown>
>;
// 后台设置小程序用户标签
export type changeUserTagType = InterFunction<
  {
    cooperationTagId: number;
    userAccountId: number;
  },
  NonNullable<unknown>
>;
