import {
  Modal,
  Form,
  Input,
  Button,
  Row,
  Col,
  message,
  Select,
  RadioChangeEvent,
  Radio,
  Space,
} from 'antd';
import React, { useEffect, useState } from 'react';

import { PropsType } from '~/common/interface/modal';
import { categoryDec } from '~/api/modules/goods';
import { CategoryManageAPI } from '~/api';

const typeOptions = [
  {
    value: 0,
    label: '通用分类',
  },
  {
    value: 1,
    label: '作业服务分类',
  },
  {
    value: 2,
    label: '设备分类',
  },
  {
    value: 3,
    label: '飞手分类',
  },
  {
    value: 4,
    label: '商城分类',
  },
];

interface selfPropsType {
  isModalVisible: boolean;
  handleOk?: () => void;
  handleCancel?: () => void;
  editData?: categoryDec; //编辑数据
}

const AddOrEditDec: React.FC<PropsType & selfPropsType> = ({
  isModalVisible,
  handleOk,
  handleCancel,
  editData,
}) => {
  const [form] = Form.useForm<any>();
  const [hasPid, setHasPid] = useState(false); //是否有上级目录
  const [submitLoading, setSubmitLoading] = useState(false); //提交按钮的loading
  const [directoryOptions, setDirectoryOptions] = useState([]); //目录options

  useEffect(() => {
    if (isModalVisible) {
      if (editData) {
        form.setFieldValue('type', editData.type);
        form.setFieldValue('pid', editData.pid);
        form.setFieldValue('directoryName', editData.directoryName);
        onChangeType(editData.type);

        if (editData.pid) {
          setHasPid(true);
        } else {
          setHasPid(false);
        }
      }
    }
  }, [isModalVisible]);

  const onChangeType = (value) => {
    console.log('value', value);
    form.resetFields(['pid']);
    CategoryManageAPI.directoryList({ pageNo: 1, pageSize: 999, type: value }).then((res) => {
      setDirectoryOptions(res.result?.list || []);
    });
  };

  //提交
  const onFinish = async () => {
    const values = await form.validateFields();
    console.log('values', values);
    setSubmitLoading(true);
    try {
      const res = await CategoryManageAPI.addOrEditDirectory({
        ...values,
        id: editData?.id,
        pid: hasPid ? values.pid : null,
      });
      res.code == '200' && message.success('新增成功');
      handleOk();
      setTimeout(() => {
        form.resetFields();
      }, 500);
    } catch (e) {}
    setSubmitLoading(false);
  };

  return (
    <Modal
      title='新增目录'
      open={isModalVisible}
      onOk={onFinish}
      onCancel={() => {
        form.resetFields();
        handleCancel();
      }}
      okButtonProps={{ loading: submitLoading }}
    >
      <Form
        form={form}
        labelCol={{ span: 6 }}
        wrapperCol={{ span: 16 }}
        style={{ marginBottom: 40 }}
      >
        <Form.Item label='分类模块' name='type' rules={[{ required: true }]}>
          <Select options={typeOptions} allowClear={true} onChange={onChangeType}></Select>
        </Form.Item>
        <Form.Item label='目录类型'>
          <Radio.Group onChange={(e: RadioChangeEvent) => setHasPid(e.target.value)} value={hasPid}>
            <Radio value={false}>无关联目录</Radio>
            <Radio value={true}>有关联目录</Radio>
          </Radio.Group>
        </Form.Item>
        {hasPid && (
          <Form.Item label='上级目录' name='pid' rules={[{ required: true }]}>
            <Select
              options={directoryOptions}
              fieldNames={{ label: 'directoryName', value: 'id' }}
              allowClear={true}
            ></Select>
          </Form.Item>
        )}

        <Form.Item label='目录名称' name='directoryName' rules={[{ required: true }]}>
          <Input placeholder='请输入目录名称' allowClear={true}></Input>
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default AddOrEditDec;
