import React, { useEffect } from 'react';
import { Button } from 'antd';
import { getMallOrderDetailById } from '~/api/interface/orderManageType';
import { InterDataType } from '~/api/interface';
import { OrderManageAPI } from '~/api';

// 接口返回的类型
type DataType = InterDataType<getMallOrderDetailById>;
// 参数类型
type PropsType = {
  detail: DataType;
};
const DetailDelivery: React.FC<PropsType> = (props) => {
  const { detail } = props;
  // 物流列表
  const [expressList, setExpressList] = React.useState<{ label: string; value: string }[]>([]);
  // 获取物流信息
  const getListExpressInfo = async () => {
    const res = await OrderManageAPI.listExpressInfo({});
    if (res && res.code === '200') {
      setExpressList(res.result.map((item) => ({ label: item.exName, value: item.exCode })));
      // console.log(res);
    }
  };
  // 转换物流信息
  const getExpressInfo = (code: string | undefined | null) => {
    return expressList.find((item) => item.value === code)?.label || code;
  };
  // componentDidMount
  useEffect(() => {
    getListExpressInfo().then();
  }, []);
  return (
    <div className={'detail-delivery detail-half'}>
      <div className={'detail-title'}>发货信息</div>
      <div className={'detail-text'}>收货人：{detail?.receipt?.takeName}</div>
      <div className={'detail-text'}>手机号：{detail?.receipt?.takePhone}</div>
      <div className={'detail-text'}>收货地址：{detail?.receipt?.detailAddress}</div>
      <div className={'detail-text'}>物流单号：{detail?.receipt?.sendExNo}</div>
      <div className={'detail-text'}>物流公司：{getExpressInfo(detail?.receipt?.sendExCode)}</div>
      <div className={'detail-text'}>
        物流进度：-- <Button type={'link'}>查看详情</Button>
      </div>

      <div className={'detail-title'}>归还信息</div>
      <div className={'detail-text'}>收货人：{detail?.receipt?.renName}</div>
      <div className={'detail-text'}>手机号：{detail?.receipt?.renPhone}</div>
      <div className={'detail-text'}>收货地址：{detail?.receipt?.renAddress}</div>
      <div className={'detail-text'}>物流单号：{detail?.receipt?.renExNo}</div>
      <div className={'detail-text'}>物流公司：{getExpressInfo(detail?.receipt?.renExCode)}</div>
      <div className={'detail-text'}>
        物流进度：-- <Button type={'link'}>查看详情</Button>
      </div>
    </div>
  );
};

export default DetailDelivery;
