import './index.scss';
import { Button, Cascader, Form, Radio, Table } from 'antd';
import EditableCell from '~/components/EditableCell';
import { useState } from 'react';
import { PlusOutlined } from '@ant-design/icons';
type EditableTableProps = Parameters<typeof Table>[0];
type ColumnTypes = Exclude<EditableTableProps['columns'], undefined>;

const RentAttr = () => {
  const typeList = [
    {
      label: '航拍无人机',
      value: 1,
    },
    {
      label: '行业无人机',
      value: 2,
    },
    {
      label: '挂载',
      value: 3,
    },
    {
      label: '配件',
      value: 4,
    },
  ];

  const attrTableColumns: (ColumnTypes[number] & {
    editable?: boolean;
    dataIndex?: string;
    inputType?: string;
    rules?: any;
    maxLength?: number;
  })[] = [
    {
      title: '参数名称',
      dataIndex: '',
      editable: true,
      align: 'center',
    },
    {
      title: '参数值',
      dataIndex: '',
      editable: true,
      align: 'center',
    },
    {
      title: '操作',
      dataIndex: '',
      render: () => <Button icon={<PlusOutlined />}></Button>,
    },
  ];
  const columns = attrTableColumns.map((col) => {
    if (!col.editable) {
      return col;
    }
    return {
      ...col,
      onCell: (record: any) => ({
        record,
        dataIndex: col.dataIndex,
        title: col.title,
        editing: col.editable,
        inputType: col.inputType,
        rules: col.rules,
      }),
    };
  });
  const [parameterTableData, setParameterTableData] = useState<any>([{ id: 1 }]);

  return (
    <div className='rent-attr'>
      <div className='rent-attr-title'>商品属性</div>
      <Form labelCol={{ span: 2 }} wrapperCol={{ span: 10 }}>
        <Form.Item label='商品类型'>
          <Radio.Group>
            {typeList.map((v) => (
              <Radio key={v.value} value={v.value}>
                {v.label}
              </Radio>
            ))}
          </Radio.Group>
        </Form.Item>
        <Form.Item label='商品型号'>
          <Cascader placeholder='请选择商品型号' />
        </Form.Item>
        <Form.Item label='商品参数'>
          <Form>
            <Table
              columns={columns as ColumnTypes}
              components={{
                body: {
                  cell: EditableCell,
                },
              }}
              dataSource={parameterTableData}
              bordered
              rowKey='id'
              pagination={false}
            ></Table>
          </Form>
        </Form.Item>
      </Form>
    </div>
  );
};
export default RentAttr;
