import { InterItemFunction } from '~/api/interface';

export type MakeListType = InterItemFunction<
  any,
  {
    createTime: string;
    brandName: string;
    id: number;
  }[]
>;
//产品-列表
export type productListType = InterItemFunction<
  { categoryId?: number; directoryId?: number; productName?: string },
  {
    id: number;
    productName: string;
    productBrandId: number;
    productBrand: string;
    model: string;
    categoriesId: number;
    categoryName: string;
    directoryId: number;
    directoryName: string;
    productSpecList: {
      id: number;
      partNo: string;
      specImage: string;
      specName: string;
      versionDesc: string;
      productSkuId: number;
    }[];
  }[]
>;
//产品-规格-列表
export type ProductSpecListType = InterItemFunction<
  { productSkuId: number },
  {
    id: number;
    partNo: string;
    specImage: string;
    specName: string;
    versionDesc: string;
    productSkuId: number;
  }[]
>;
