import { useEffect, useState } from 'react';
import { useNavigate, useSearchParams } from 'react-router-dom';
import { Button } from 'antd';
import './index.scss';
import DetailDelivery from './comp/detailDelivery';
import DetailPurchaser from './comp/detailPurchaser';
import DetailInformation from './comp/detailInformation';
import { mallOrderDetailType } from '~/api/interface/orderManageType';
import { InterDataType } from '~/api/interface';
import { OrderManageAPI } from '~/api';

// 接口返回的类型
type DataType = InterDataType<mallOrderDetailType>;

function ProductOrderDetail() {
  // 路由钩子
  const navigate = useNavigate();
  // 参数钩子
  const [searchParams] = useSearchParams();
  // 接收到的参数
  const id = searchParams.get('id');
  // 返回上一页
  const handleBack = () => {
    navigate(-1);
  };
  // 订单详情
  const [orderDetail, setOrderDetail] = useState<DataType>();
  // 获取订单详情
  const getOrderDetail = async () => {
    const res = await OrderManageAPI.getMallOrderDetail({
      id: Number(id),
    });
    if (res && res.code === '200') {
      setOrderDetail(res.result);
    }
  };

  // componentDidMount
  useEffect(() => {
    getOrderDetail().then();
  }, []);
  return (
    <div className='order-detail'>
      <div className='order-head'>
        <Button type='primary' onClick={() => handleBack()}>
          返回
        </Button>
      </div>
      <div className='detail-wrap'>
        <DetailPurchaser detail={orderDetail} />
        <DetailDelivery detail={orderDetail} />
        <DetailInformation detail={orderDetail} />
      </div>
    </div>
  );
}

export default ProductOrderDetail;
